Tea.context(function () {
	this.$delay(function () {

		// 初始化图表
		let ipChart = echarts.init(document.getElementById('ip-chart'));
		let pathChart = echarts.init(document.getElementById('path-chart'));
		let domainChart = echarts.init(document.getElementById('domain-chart'));

		// --- IP 排行图表 ---
		let ipData = this.ipAccessStats; 
		let ipOptions = {
			tooltip: {
				trigger: 'axis',
				axisPointer: {
					type: 'shadow'
				},
				formatter: function (params) {
					let item = ipData[params[0].dataIndex];
					return item.ip + '<br/>访问次数: ' + item.requestCount + '<br/>访问流量: ' + Tea.formatBytes(item.sentBodyBytes);
				}
			},
			grid: {
				left: '3%',
				right: '4%',
				bottom: '3%',
				containLabel: true
			},
			xAxis: [
				{
					type: 'category',
					data: ipData.map(item => item.ip),
					axisTick: {
						alignWithLabel: true
					}
				}
			],
			yAxis: [
				{
					type: 'value',
					name: '访问次数'
				}
			],
			series: [
				{
					name: '访问次数',
					type: 'bar',
          itemStyle: {
            color: getCssVariable('--color-text-active','#app'),
          },
					data: ipData.map(item => item.requestCount)
				}
			]
		};
		ipChart.setOption(ipOptions);

		// --- 路径 排行图表 ---
		let pathData = this.pathAccessStats;
		let pathOptions = {
			tooltip: {
				trigger: 'axis',
				axisPointer: {
					type: 'shadow'
				},
				formatter: function (params) {
					let item = pathData[params[0].dataIndex];
					return item.path + '<br/>访问次数: ' + item.requestCount + '<br/>访问流量: ' + Tea.formatBytes(item.sentBodyBytes);
				}
			},
			grid: {
				left: '3%',
				right: '4%',
				bottom: '3%',
				containLabel: true
			},
			xAxis: [
				{
					type: 'category',
					data: pathData.map(item => item.path),
					axisLabel: { // 路径可能过长，进行处理
						interval: 0,
						rotate: 30, // 旋转30度
						formatter: function (value) {
							return value.length > 20 ? value.substring(0, 20) + '...' : value;
						}
					},
					axisTick: {
						alignWithLabel: true
					}
				}
			],
			yAxis: [
				{
					type: 'value',
					name: '访问次数'
				}
			],
			series: [
				{
					name: '访问次数',
					type: 'bar',
          itemStyle: {
            color: getCssVariable('--color-text-active','#app'),
          },
					data: pathData.map(item => item.requestCount)
				}
			]
		};
		pathChart.setOption(pathOptions);

		// --- 域名 排行图表 ---
		let domainData = this.domainAccessStats;
		let domainOptions = {
			tooltip: {
				trigger: 'axis',
				axisPointer: {
					type: 'shadow'
				},
				formatter: function (params) {
					let item = domainData[params[0].dataIndex];
					return item.domain + '<br/>访问次数: ' + item.requestCount + '<br/>访问流量: ' + Tea.formatBytes(item.sentBodyBytes);
				}
			},
			grid: {
				left: '3%',
				right: '4%',
				bottom: '3%',
				containLabel: true
			},
			xAxis: [
				{
					type: 'category',
					data: domainData.map(item => item.domain),
					axisTick: {
						alignWithLabel: true
					}
				}
			],
			yAxis: [
				{
					type: 'value',
					name: '访问次数'
				}
			],
			series: [
				{
					name: '访问次数',
					type: 'bar',
          itemStyle: {
            color: getCssVariable('--color-text-active','#app'),
          },
					data: domainData.map(item => item.requestCount)
				}
			]
		};
		domainChart.setOption(domainOptions);

		// 监听窗口大小变化，重新渲染图表
		window.addEventListener('resize', function () {
			ipChart.resize();
			pathChart.resize();
			domainChart.resize();
		});
	})
})
