Tea.context(function () {
	// 定义表格列
	this.columns = [
		{
			title: '',
			key: 'handle',
			scopedSlots: { customRender: 'handleSlot' },
			width: '50px',
			align: 'center'
		},
		{
			title: '规则分组',
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' },
			width: '400px'
		},
		{
			title: '规则集',
			key: 'countSets',
			scopedSlots: { customRender: 'countSetsSlot' },
			width: '100px',
			align: 'center'
		},
		{
			title: '操作',
			key: 'operation',
			scopedSlots: { customRender: 'operationSlot' },
			width: '250px',
			align: 'center',
		}
	]

	// 处理拖拽排序
	this.handleSort = function (ids) {
		this.$post("/servers/components/waf/sortGroups")
			.params({
				firewallPolicyId: this.firewallPolicyId,
				type: this.type,
				groupIds: ids
			})
			.success(function () {
				teaweb.successToast("排序保存成功")
			})
	}

	// 启用
	this.enableGroup = function (groupId) {
		this.$post("/servers/components/waf/updateGroupOn")
			.params({
				groupId: groupId,
				isOn: 1
			})
			.refresh()
	}

	// 停用
	this.disableGroup = function (groupId) {
		this.$post("/servers/components/waf/updateGroupOn")
			.params({
				groupId: groupId,
				isOn: 0
			})
			.refresh()
	}

	// 删除
	this.deleteGroup = function (groupId) {
		teaweb.confirm("确定要删除此规则分组吗？", function () {
			this.$post("/servers/components/waf/deleteGroup")
				.params({
					firewallPolicyId: this.firewallPolicyId,
					groupId: groupId
				})
				.refresh()
		})
	}

	// 添加分组
	this.createGroup = function (type) {
		teaweb.popup("/servers/components/waf/createGroupPopup?firewallPolicyId=" + this.firewallPolicyId + "&type=" + type, {
			width: "50em",
			height: "40em",
			title: '创建分组',
			callback: function () {
				teaweb.success("保存成功", function () {
					window.location.reload()
				})
			}
		})
	}
})