Tea.context(function () {
	this.$delay(function () {
		this.loadStatus()
	})

	this.loadStatus = function () {
		let serverIds = this.servers.map(function (v) {
			return v.id
		})
		this.$post(".status")
			.params({
				serverIds: serverIds
			})
			.timeout(300)
			.success(function (resp) {
				let status = resp.data.status
				this.servers.forEach(function (server) {
					if (typeof status[server.id] === "object") {
						server.status = status[server.id]
					}
				})
			})
	}
	this.searchServers = function () {
		document.getElementById("searchForm").submit();
	}

	this.deleteServer = function (serverId) {
		let that = this
		teaweb.confirm("确定要删除此域名吗？", function () {
			that.$post(".delete")
				.params({
					serverId: serverId
				})
				.refresh()
		})
	}

	this.updateServerOn = function (serverId) {
		let that = this
		teaweb.confirm("确定要启用此域名吗？", function () {
			that.$post(".updateOn")
				.params({
					serverId: serverId,
					isOn: true
				})
				.refresh()
		})
	}

	this.updateServerOff = function (serverId) {
		let that = this
		teaweb.confirm("确定要停用此域名吗？", function () {
			that.$post(".updateOn")
				.params({
					serverId: serverId,
					isOn: false
				})
				.refresh()
		})
	}

	this.updateServerName = function (serverId) {
		teaweb.popup("/servers/updateNamePopup?serverId=" + serverId, {
			title: '修改网站名称',
			callback: function () {
				teaweb.success("保存成功", function () {
					teaweb.reload()
				})
			}
		})
	}

	/**
	 * 全选
	 */
	this.checkedServerIds = []
	
	// 重构选择逻辑，不再使用 checkbox ref
	this.changeAllChecked = function (checked) {
		if (checked) {
			// 全选
			this.checkedServerIds = this.servers.map(function (server) {
				return server.id
			})
		} else {
			// 取消全选
			this.checkedServerIds = []
		}
	}

	this.updateCheckedServers = function () {
		// 在antd表格组件中，选中项通过row-selection的onChange处理
		// 现在这个函数主要用于触发UI更新
		this.$forceUpdate()
	}

	this.resetCheckedServers = function () {
		// 清空选择
		this.checkedServerIds = []
		this.updateCheckedServers()
	}

	this.deleteServers = function () {
		let that = this
		teaweb.confirm("确定要删除所选的" + (this.checkedServerIds.length) + "个网站吗？", function () {
			that.$post(".deleteServers")
				.params({
					serverIds: that.checkedServerIds // 修改this为that
				})
				.success(function () {
					teaweb.reload()
				})
		})
	}

	this.createServer = function () {
		window.location.href = "/servers/create"
	}

	this.preheatServers = function () {
		console.log("preheatServers")
	}

	this.applyCertificates = function () {
		window.location.href = "/servers/certs/acme/create"
	}

	this.goToServer = function (serverId) {
		window.location.href = "/servers/server?serverId=" + serverId
	}

	this.changeHTTPS = function (record, isOn) {
		this.$set(record, "loading", true)
		// 调用接口
		this.$post("/servers/server/settings/https")
			.params({
				serverId: record.id,
				isOn: isOn ? 1 : 0
			})
			.success(function () {
				teaweb.reload()
			})
			.done(function () {
				this.$set(record, "loading", false)
			})
	}

	// 定义表格列
	this.columns = [
		{
			title: '域名',
			dataIndex: 'serverNames',
			key: 'serverNames',
			width: 250,
			scopedSlots: { customRender: 'domainNames' },
		},
		{
			title: '分组',
			dataIndex: 'groups',
			key: 'groups',
			width: 120,
			scopedSlots: { customRender: 'groups' },
		},
		{
			title: '网站名称',
			dataIndex: 'name',
			key: 'name',
			width: 250,
			scopedSlots: { customRender: 'websiteName' },
		},
		{
			title: '套餐',
			dataIndex: 'userPlan',
			key: 'userPlan',
			width: 200,
			scopedSlots: { customRender: 'userPlan' },
		},
		{
			title: '网站类型',
			dataIndex: 'serverType',
			key: 'serverType',
			width: 120,
			scopedSlots: { customRender: 'serverType' }
		},
		{
			title: 'CNAME',
			dataIndex: 'cname',
			key: 'cname',
			width: 220,
			scopedSlots: { customRender: 'cname' }
		},
		{
			title: '状态',
			dataIndex: 'status',
			key: 'status',
			width: 150,
			scopedSlots: { customRender: 'status' }
		},
		// {
		// 	title: 'HTTP',
		// 	dataIndex: 'httpIsOn',
		// 	key: 'httpIsOn',
		// 	width: 80,
		// 	scopedSlots: { customRender: 'httpIsOn' }
		// },
		{
			title: 'HTTPS',
			dataIndex: 'httpsIsOn',
			key: 'httpsIsOn',
			width: 80,
			scopedSlots: { customRender: 'httpsIsOn' }
		},
		{
			title: '操作',
			key: 'action',
			width: 250,
			scopedSlots: { customRender: 'action' },
		}
	]
})