Tea.context(function () {
	// 定义表格列
	this.columns = [
		{
			title: 'ACME用户',
			dataIndex: 'acmeUser',
			key: 'acmeUser',
			scopedSlots: { customRender: 'acmeUserSlot' }
		},
		{
			title: '证书域名',
			dataIndex: 'domains',
			key: 'domains',
			scopedSlots: { customRender: 'domainsSlot' }
		},
		{
			title: '到期时间',
			dataIndex: 'endTime',
			key: 'endTime',
			width: '150px',
			scopedSlots: { customRender: 'endTimeSlot' }
		},
		{
			title: '更新时间',
			dataIndex: 'updateTime',
			key: 'updateTime',
			width: '150px',
			scopedSlots: { customRender: 'updateTimeSlot' }
		},
		{
			title: '自动续期',
			dataIndex: 'autoRenew',
			key: 'autoRenew',
			width: '100px',
			align: 'center',
			scopedSlots: { customRender: 'autoRenewSlot' }
		},
		{
			title: '关联证书',
			dataIndex: 'cert',
			key: 'cert',
			width: '100px',
			align: 'center',
			scopedSlots: { customRender: 'certSlot' }
		},
		{
			title: '操作',
			key: 'action',
			width: '230px',
			align: 'center',
			fixed: 'right',
			scopedSlots: { customRender: 'actionSlot' }
		}
	];

	this.viewCert = function (certId) {
		teaweb.popup("/servers/certs/certPopup?certId=" + certId, {
			height: "28em",
			width: "48em",
			title: '查看证书'
		})
	}

	this.updateTask = function (taskId) {
		teaweb.popup("/servers/certs/acme/updateTaskPopup?taskId=" + taskId, {
			width: "45em",
			height: "26em",
			title: '修改任务',
			callback: function () {
				teaweb.success("保存成功，如果证书域名发生了改变，请重新执行生成新证书", function () {
					teaweb.reload()
				})
			}
		})
	}

	this.deleteTask = function (taskId) {
		let that = this
		teaweb.confirm("确定要删除此任务吗？", function () {
			that.$post("/servers/certs/acme/deleteTask")
				.params({
					taskId: taskId
				})
				.refresh()
		})
	}

	this.isRunning = false
	this.runningIndex = -1

	this.runTask = function (taskId) {
		let that = this
		const task = this.tasks.find(t => t.id === taskId);
		if (!task) return;

		teaweb.confirm("html:确定要立即执行此任务吗？<br/>将会重新发起证书申请。", function () {
			that.isRunning = true
			that.runningIndex = that.tasks.findIndex(t => t.id === taskId);

			that.$post(".run")
				.timeout(300)
				.params({
					taskId: taskId
				})
				.success(function (resp) {
					teaweb.success("任务执行成功", function () {
						teaweb.reload()
					})
				})
				.done(function () {
					that.isRunning = false
					that.runningIndex = -1
				})
		})
	}

	this.showError = function (err) {
		teaweb.popupTip("任务执行失败：" + err)
	}
})