Tea.context(function () {
	// 定义表格列
	this.columns = [
		{
			title: '套餐',
			dataIndex: 'plan',
			key: 'plan',
			scopedSlots: { customRender: 'planSlot' },
			width: '200px'
		},
		{
			title: '备注名',
			dataIndex: 'name',
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' },
			width: '150px'
		},
		{
			title: '价格设置',
			dataIndex: 'plan',
			key: 'price',
			scopedSlots: { customRender: 'priceSlot' },
			width: '300px'
		},
		{
			title: '有效期',
			dataIndex: 'dayTo',
			key: 'dayTo',
			scopedSlots: { customRender: 'dayToSlot' },
			width: '150px',
			align: 'center'
		},
		{
			title: '网站',
			dataIndex: 'servers',
			key: 'servers',
			scopedSlots: { customRender: 'serversSlot' },
			width: '200px'
		},
		{
			title: '操作',
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '200px',
			align: 'center',
			fixed: 'right'
		}
	];

	this.deleteUserPlan = function (userPlanId) {
		teaweb.confirm("确定要删除此套餐吗？", function () {
			this.$post(".delete")
				.params({
					userPlanId: userPlanId
				})
				.refresh()
		})
	}

	this.renewUserPlan = function (userPlanId) {
		teaweb.popupSuccess(".renewPopup?userPlanId=" + userPlanId, null, "27em")
	}
})