Tea.context(function () {
	// 定义表格列
	this.columns = [
		{
			title: '',
			dataIndex: 'handle',
			key: 'handle',
			scopedSlots: { customRender: 'handleSlot' },
			width: '50px',
			align: 'center'
		},
		{
			title: '线路名称',
			dataIndex: 'name',
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' },
			width: '300px'
		},
		{
			title: '代号',
			dataIndex: 'id',
			key: 'code',
			scopedSlots: { customRender: 'codeSlot' },
			width: '150px'
		},
		{
			title: '状态',
			dataIndex: 'isOn',
			key: 'status',
			scopedSlots: { customRender: 'statusSlot' },
			width: '150px',
			align: 'center'
		},
		{
			title: '操作',
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '200px',
			align: 'center',
			fixed: 'right'
		}
	];



	// let that = this
	// 处理拖拽排序
	this.handleSort = function (ids) {
		console.log("this.handleSort -> ids", ids)
		this.$post(".sort")
			.params({
				routeIds: ids
			})
			.success(function () {
				teaweb.successToast("排序保存成功");
			});
	};

	this.createRoute = function () {
		teaweb.popup("/ns/routes/createPopup", {
			width: "50em",
			height: "30em",
			title: '创建路由',
			callback: function () {
				teaweb.success("保存成功", function () {
					teaweb.reload()
				})
			}
		})
	}

	this.updateRoute = function (routeId) {
		teaweb.popup("/ns/routes/updatePopup?routeId=" + routeId, {
			width: "50em",
			height: "30em",
			title: '修改路由',
			callback: function () {
				teaweb.success("保存成功", function () {
					teaweb.reload()
				})
			}
		})
	}

	this.deleteRoute = function (routeId) {
		let that = this
		teaweb.confirm("确定要删除此线路吗？", function () {
			that.$post(".delete")
				.params({
					routeId: routeId
				})
				.success(function () {
					teaweb.reload()
				})
		})
	}
})