Tea.context(function () {
	this.$delay(function () {
		this.changeUserId(this.userId)
	})

	this.deleteDomain = function (domainId) {
		let that = this
		teaweb.confirm("确定要删除此域名吗？", function () {
			that.$post("/ns/domains/delete")
				.params({
					domainId: domainId
				})
				.success(function () {
					teaweb.reload()
				})
		})
	}

	this.verifyDomain = function (domainId) {
		teaweb.popup("/ns/domains/domain/verifyPopup?domainId=" + domainId, {
			height: "25em",
			title: '验证域名',
			callback: function () {

			}
		})
	}

	this.hasGroups = false
	this.changeUserId = function (userId) {
		this.$post("/ns/domains/groups/options")
			.params({
				userId: userId
			})
			.success(function (resp) {
				this.hasGroups = resp.data.groups.length > 0
				if (this.hasGroups) {
					this.$delay(function () {
						this.$refs.groupSelector.reload(userId)
					})
				}
			})
	}

	/**
	 * 批量操作
	 */
	this.selectedAll = false
	this.hasSelectedDomains = false
	this.hasVerifyingDomains = false
	this.selectedDomainIds = []

	this.$delay(function () {
		let that = this
		this.$watch("selectedAll", function (b) {
			let checkboxes = that.$refs.domainCheckbox
			if (checkboxes != null) {
				checkboxes.forEach(function (checkbox) {
					if (b) {
						checkbox.check()
						that.hasSelectedDomains = true
						let status = checkbox.$el.getAttribute("status")
						if (status == "none") {
							that.hasVerifyingDomains = true
						}
					} else {
						checkbox.uncheck()
						that.hasSelectedDomains = false
					}
				})
			}
		})
	})

	this.changeSelectedDomains = function () {
		if (this.$refs == null) {
			return
		}
		let checkboxes = this.$refs.domainCheckbox
		if (checkboxes != null) {
			let hasSelectedDomains = false
			let hasVerifyingDomains = false
			checkboxes.forEach(function (checkbox) {
				if (checkbox.isChecked()) {
					hasSelectedDomains = true
					let status = checkbox.$el.getAttribute("status")
					if (status == "none") {
						hasVerifyingDomains = true
					}
				}
			})
			this.hasSelectedDomains = hasSelectedDomains
			this.hasVerifyingDomains = hasVerifyingDomains
			return
		}
	}

	this.cancelDomains = function () {
		let checkboxes = this.$refs.domainCheckbox
		checkboxes.forEach(function (checkbox) {
			checkbox.uncheck()
		})
		this.selectedAll = false
		this.hasSelectedDomains = false
		this.hasVerifyingDomains = false
		this.selectedDomainIds = []
	}

	this.deleteDomains = function () {
		let checkboxes = this.$refs.domainCheckbox
		let domainIds = []
		checkboxes.forEach(function (checkbox) {
			if (checkbox.isChecked()) {
				let domainId = checkbox.vValue
				if (typeof domainId == "number") {
					domainIds.push(domainId)
				}
			}
		})
		let that = this
		teaweb.confirm("确定要删除选中的域名吗？", function () {
			that.$post(".deletePage")
				.params({
					domainIds: domainIds
				})
				.success(function () {
					teaweb.successRefresh("删除成功")
				})
		})
	}

	this.verifyDomains = function () {
		let checkboxes = this.$refs.domainCheckbox
		let domainIds = []
		checkboxes.forEach(function (checkbox) {
			if (checkbox.isChecked()) {
				let domainId = checkbox.vValue
				if (typeof domainId == "number") {
					domainIds.push(domainId)
				}
			}
		})
		let that = this
		teaweb.confirm("html:确定要批量验证选中的域名吗？<br/>在此之前请确保这些域名已经设置了NS记录。<br/>已经验证过的域名，不再重复验证。", function () {
			that.$post(".verifyPage")
				.params({
					domainIds: domainIds
				})
				.success(function () {
					teaweb.successRefresh("验证成功")
				})
		})
	}

	// 定义表格列
	this.columns = [
		{
			title: '域名',
			dataIndex: 'name',
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' },
			width: '400px'
		},
		{
			title: '状态',
			dataIndex: 'status',
			key: 'status',
			scopedSlots: { customRender: 'statusSlot' },
			width: '150px',
			align: 'center'
		},
		{
			title: '操作',
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '200px',
			align: 'center',
			fixed: 'right'
		}
	]

	this.updateSelectedDomains = function () {
		this.hasSelectedDomains = this.selectedDomainIds.length > 0
		this.hasVerifyingDomains = this.selectedDomainIds.length > 0
	}

	this.goToDomain = function (domainId) {
		window.location.href = '/ns/domains/domain?domainId=' + domainId
	}
})