Tea.context(function () {
	// 定义表格列
	this.columns = [
		{
			title: '网站名称',
			dataIndex: 'name',
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' },
			width: '300px'
		},
		{
			title: 'CNAME',
			dataIndex: 'cname',
			key: 'cname',
			scopedSlots: { customRender: 'cnameSlot' },
			width: '200px'
		},
		{
			title: 'TCP',
			dataIndex: 'tcpPorts',
			key: 'tcpPorts',
			scopedSlots: { customRender: 'tcpPortsSlot' },
			width: '150px',
			align: 'center',
			vIf: 'supportTCP'
		},
		{
			title: 'TLS',
			dataIndex: 'tlsPorts',
			key: 'tlsPorts',
			scopedSlots: { customRender: 'tlsPortsSlot' },
			width: '150px',
			align: 'center',
			vIf: 'supportTCP'
		},
		{
			title: 'UDP',
			dataIndex: 'udpPorts',
			key: 'udpPorts',
			scopedSlots: { customRender: 'udpPortsSlot' },
			width: '150px',
			align: 'center',
			vIf: 'supportUDP'
		},
		{
			title: '状态',
			dataIndex: 'isOn',
			key: 'status',
			scopedSlots: { customRender: 'statusSlot' },
			width: '100px',
			align: 'center'
		},
		{
			title: '操作',
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '150px',
			align: 'center',
			fixed: 'right'
		}
	];

	// 添加跳转方法
	this.goToServer = function(serverId) {
		window.location.href = '/lb/server?serverId=' + serverId;
	};

	this.deleteServer = function (serverId) {
		let that = this
		teaweb.confirm("确定要删除此网站吗？", function () {
			that.$post(".delete")
				.params({
					serverId: serverId
				})
				.refresh()
		})
	}

	this.updateServerOn = function (serverId) {
		let that = this
		teaweb.confirm("确定要启用此网站吗？", function () {
			that.$post(".updateOn")
				.params({
					serverId: serverId,
					isOn: true
				})
				.refresh()
		})
	}

	this.updateServerOff = function (serverId) {
		let that = this
		teaweb.confirm("确定要停用此网站吗？", function () {
			that.$post(".updateOn")
				.params({
					serverId: serverId,
					isOn: false
				})
				.refresh()
		})
	}
})