Tea.context(function () {
	// 在页面加载完成后初始化
	this.$delay(function() {
		this.initMobileMenu();
		this.highlightActiveTOCItems();
		this.initScrollSpy();
	});
	
	// 初始化移动端菜单
	this.initMobileMenu = function() {
		let sidebar = document.querySelector('.sidebar-menu');
		let toggleButton = document.querySelector('.toggle-button');
		
		// 检查是否已经有其他地方添加了事件监听
		if (!window.hasMenuToggleHandler) {
			toggleButton.addEventListener('click', function() {
				sidebar.classList.toggle('mobile-expanded');
				toggleButton.classList.toggle('active');
				
				let toggleText = toggleButton.querySelector('span');
				if (sidebar.classList.contains('mobile-expanded')) {
					toggleText.innerText = '隐藏目录';
				} else {
					toggleText.innerText = '显示目录';
				}
			});
			
			window.hasMenuToggleHandler = true;
		}
		
		// 点击目录中的链接时自动关闭菜单（移动端）
		let menuLinks = sidebar.querySelectorAll('a');
		menuLinks.forEach(link => {
			link.addEventListener('click', function() {
				if (window.innerWidth <= 768) {
					sidebar.classList.remove('mobile-expanded');
					toggleButton.classList.remove('active');
					toggleButton.querySelector('span').innerText = '显示目录';
				}
			});
		});
	};
	
	// 根据当前URL高亮对应的目录项
	this.highlightActiveTOCItems = function() {
		let currentPath = window.location.pathname;
		let links = document.querySelectorAll('.sidebar-menu a');
		
		links.forEach(link => {
			if (link.getAttribute('href') === currentPath) {
				link.classList.add('active');
				
				// 展开父级菜单（如果存在）
				let parent = link.parentElement;
				while (parent) {
					if (parent.tagName === 'LI') {
						if (parent.querySelector('ul')) {
							parent.classList.add('expanded');
						}
					}
					parent = parent.parentElement;
				}
			}
		});
	};
	
	// 初始化滚动监听，高亮右侧导航中当前可见的标题
	this.initScrollSpy = function() {
		// 只有在非移动设备上初始化滚动监听（因为移动设备上右侧导航不显示）
		if (window.innerWidth <= 1200) {
			return;
		}
		
		let headings = document.querySelectorAll('.content-wrapper h1, .content-wrapper h2, .content-wrapper h3');
		let tocLinks = document.querySelectorAll('.page-toc a');
		
		if (headings.length === 0 || tocLinks.length === 0) {
			return;
		}
		
		// 监听滚动事件
		window.addEventListener('scroll', function() {
			let scrollPosition = window.scrollY;
			
			// 找到当前滚动位置对应的标题
			let currentHeading = null;
			headings.forEach(heading => {
				if (heading.offsetTop <= scrollPosition + 100) {
					currentHeading = heading;
				}
			});
			
			if (currentHeading) {
				let id = currentHeading.getAttribute('id');
				
				// 移除所有活动状态
				tocLinks.forEach(link => {
					link.classList.remove('active');
				});
				
				// 添加当前活动链接的活动状态
				tocLinks.forEach(link => {
					let href = link.getAttribute('href');
					if (href && href.endsWith('#' + id)) {
						link.classList.add('active');
					}
				});
			}
		});
		
		// 初始触发一次滚动事件以设置初始状态
		window.dispatchEvent(new Event('scroll'));
	};
	
	// 监听窗口大小变化，适应响应式布局
	window.addEventListener('resize', function() {
		// 当从移动尺寸变回大尺寸时，移除展开类
		if (window.innerWidth > 768) {
			let sidebar = document.querySelector('.sidebar-menu');
			if (sidebar) {
				sidebar.classList.remove('mobile-expanded');
			}
			
			let toggleButton = document.querySelector('.toggle-button');
			if (toggleButton) {
				toggleButton.classList.remove('active');
				let toggleText = toggleButton.querySelector('span');
				if (toggleText) {
					toggleText.innerText = '显示目录';
				}
			}
		}
	});
})