Tea.context(function () {
	this.columns = [
		{
			title: 'AccessKey ID',
			key: 'uniqueId',
			scopedSlots: { customRender: 'uniqueIdSlot' },
			width: '300px'
		},
		{
			title: 'AccessKey密钥',
			key: 'secret',
			scopedSlots: { customRender: 'secretSlot' },
			width: '300px'
		},
		{
			title: '备注',
			key: 'description',
			scopedSlots: { customRender: 'descriptionSlot' }
		},
		{
			title: '状态',
			key: 'status',
			scopedSlots: { customRender: 'statusSlot' },
			width: '100px'
		},
		{
			title: '操作',
			key: 'operation',
			scopedSlots: { customRender: 'operationSlot' },
			width: '150px',
			align: 'center',
			fixed: 'right'
		}
	];

	this.createAccessKey = function () {
		teaweb.popup("/acl/accesskeys/createPopup", {
			title: '创建AccessKey',
			callback: function () {
				teaweb.success("保存成功", function () {
					teaweb.reload()
				})
			}
		})
	}

	this.updateAccessKeyIsOn = function (accessKeyId, isOn) {
		let that = this

		let message = ""
		if (isOn) {
			message = "确定要启用此AccessKey吗？"
		} else {
			message = "确定要禁用此AccessKey吗？"
		}
		teaweb.confirm(message, function () {
			that.$post(".updateIsOn")
				.params({
					accessKeyId: accessKeyId,
					isOn: isOn ? 1 : 0
				})
				.refresh()
		})
	}

	this.deleteAccessKey = function (accessKeyId) {
		let that = this
		teaweb.confirm("确定要删除此AccessKey吗？", function () {
			that.$post(".delete")
				.params({
					accessKeyId: accessKeyId
				})
				.refresh()
		})
	}
})