Tea.context(function () {
	this.windowWidth = window.innerWidth
	this.columnWidth1 = 1000
	const t = this.t.bind(this)

	// 表格列定义 (遵循 routes 示例风格)
	this.columns = [
		{
			title: t('users_index@用户名'),
			key: 'username',
			scopedSlots: { customRender: 'usernameSlot' }
		},
		{
			title: t('users_index@全名'),
			key: 'fullname',
			scopedSlots: { customRender: 'fullnameSlot' }
		},
		{
			title: t('users_index@关联集群'),
			key: 'cluster',
			scopedSlots: { customRender: 'clusterSlot' }
		},
		{
			title: t('users_index@绑定手机号'),
			key: 'verifiedMobile',
			scopedSlots: { customRender: 'verifiedMobileSlot' }
		},
		// 联系手机号 - 条件显示，放到下面根据条件添加
		{
			title: t('users_index@注册时间'),
			dataIndex: 'createdTime', // 保持和 routes 例子一致，虽然简单文本可以省略
			key: 'createdTime',
			width: '150px'
		},
		{
			title: t('users_index@状态'),
			key: 'status',
			scopedSlots: { customRender: 'statusSlot' },
			align: 'center',
			width: '80px'
		},
		{
			title: t('users_index@操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '150px'
		}
	];

	// 根据窗口宽度动态添加 "联系手机号" 列
	if (this.windowWidth > this.columnWidth1) {
		const createdTimeIndex = this.columns.findIndex(col => col.key === 'createdTime');
		if (createdTimeIndex !== -1) {
			this.columns.splice(createdTimeIndex, 0, {
				title: t('users_index@联系手机号'),
				key: 'mobile',
				scopedSlots: { customRender: 'mobileSlot' }
			});
		}
	}

	this.createUser = function () {
		teaweb.popup(Tea.url(".createPopup"), {
			title: t('users_index@创建新用户'),
			height: "30em",
			callback: function () {
				teaweb.success(t("users_index@保存成功"), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.deleteUser = function (userId) {
		let that = this
		teaweb.confirm(t("users_index@确定要删除这个用户吗？"), function () {
			that.$post(".delete")
				.params({
					userId: userId
				})
				.refresh()
		})
	}
})