Tea.context(function () {
	const t = this.t.bind(this)
	this.columns = [
		{
			title: t('users_accesskeys_index@AccessKey ID'),
			dataIndex: 'uniqueId',
			key: 'uniqueId',
			scopedSlots: { customRender: 'uniqueIdSlot' },
		},
		{
			title: t('users_accesskeys_index@AccessKey密钥'),
			dataIndex: 'secret',
			key: 'secret',
			scopedSlots: { customRender: 'secretSlot' },
		},
		{
			title: t('users_accesskeys_index@备注'),
			dataIndex: 'description',
			key: 'description',
			scopedSlots: { customRender: 'descriptionSlot' },
		},
		{
			title: t('users_accesskeys_index@最后访问'),
			dataIndex: 'accessedTime',
			key: 'accessedTime',
			scopedSlots: { customRender: 'accessedTimeSlot' },
		},
		{
			title: t('users_accesskeys_index@状态'),
			dataIndex: 'isOn',
			key: 'status',
			scopedSlots: { customRender: 'statusSlot' },
			align: 'center'
		},
		{
			title: t('users_accesskeys_index@操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '150px',
			align: 'center'
		}
	]
	this.createAccessKey = function () {
		teaweb.popup("/users/accesskeys/createPopup?userId=" + this.user.id, {
			title: t('users_accesskeys_index@创建新AccessKey'),
			callback: function () {
				teaweb.success(t("users_accesskeys_index@保存成功"), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.updateAccessKeyIsOn = function (accessKeyId, isOn) {
		let that = this

		let message = ""
		if (isOn) {
			message = t("users_accesskeys_index@确定要启用此AccessKey吗？")
		} else {
			message = t("users_accesskeys_index@确定要禁用此AccessKey吗？")
		}
		teaweb.confirm(message, function () {
			that.$post(".updateIsOn")
				.params({
					accessKeyId: accessKeyId,
					isOn: isOn ? 1 : 0
				})
				.refresh()
		})
	}

	this.deleteAccessKey = function (accessKeyId) {
		let that = this
		teaweb.confirm(t("users_accesskeys_index@确定要删除此AccessKey吗？"), function () {
			that.$post(".delete")
				.params({
					accessKeyId: accessKeyId
				})
				.refresh()
		})
	}
})