Tea.context(function () {
	const t = this.t.bind(this)
	this.createCategory = function () {
		teaweb.popup("/tickets/categories/createPopup", {
			title: t('tickets_categories_index@添加分类'),
			callback: function () {
				teaweb.successRefresh(t("tickets_categories_index@保存成功"))
			}
		})
	}

	this.updateCategory = function (categoryId) {
		teaweb.popup("/tickets/categories/category/updatePopup?categoryId=" + categoryId, {
			title: t('tickets_categories_index@修改分类'),
			callback: function () {
				teaweb.successRefresh(t("tickets_categories_index@保存成功"))
			}
		})
	}

	this.deleteCategory = function (categoryId) {
		let that = this
		teaweb.confirm(t("tickets_categories_index@确定要删除此分类吗？"), function () {
			that.$post("/tickets/categories/category/delete")
				.params({
					categoryId: categoryId
				})
				.success(function () {
					teaweb.reload()
				})
		})
	}
})