Tea.context(function () {
	this.oldProtocol = "";
	
	this.STEP_INTRO = "intro"
	this.STEP_API = "api"
	this.STEP_DB = "db"
	this.STEP_ADMIN = "admin"
	this.STEP_FINISH = "finish"

	this.step = this.STEP_INTRO

	this.$delay(function () {
		this.loadStatusText()
	})

	// 介绍
	this.goIntroNext = function () {
		this.step = this.STEP_API
	}

	// API节点
	this.apiNodeInfo = {}
	this.apiNodeMode = "new"
	this.newAPINodePort = "8001"
	this.apiRequesting = false

	this.apiHostInput = false // 是否手工输入

	this.apiSubmit = function () {
		this.apiRequesting = true
	}

	this.apiDone = function () {
		this.apiRequesting = false
	}

	this.apiSuccess = function (resp) {
		this.step = this.STEP_DB
		this.detectDB()
		this.apiNodeInfo = resp.data.apiNode

		if (this.apiNodeMode == "new") {
			this.$delay(function () {
				this.$refs.dbHost.focus()
			}, 200)
		}
	}

	this.goBackIntro = function () {
		this.step = this.STEP_INTRO
	}

	this.inputAPIHost = function () {
		this.apiHostInput = true
		this.$delay(function () {
			this.$refs.newHostRef.focus()
		})
	}

	// 数据库
	this.dbInfo = {}
	this.localDB = {"host": "", "port": "", "username": "", "port": "", "isLocal": true, "canInstall": false}
	this.localDBHost = ""
	this.dbRequesting = false

	this.detectDB = function () {
		this.$post(".detectDB")
			.success(function (resp) {
				this.localDB = resp.data.localDB
				this.localDB["isLocal"] = true
				this.localDBHost = this.localDB.host
			})
	}

	this.checkDBIP = function () {
		this.localDB["isLocal"] = true
		if (this.localDB.host.length == 0) {
			return
		}
		this.$post(".checkLocalIP")
			.params({
				host: this.localDB.host
			})
			.success(function (resp) {
				this.localDB["isLocal"] = resp.data.isLocal
				this.$forceUpdate()
			})
	}

	this.dbSubmit = function () {
		this.dbRequesting = true
	}

	this.dbSuccess = function (resp) {
		this.step = this.STEP_ADMIN
		this.dbInfo = resp.data.db

		this.$delay(function () {
			if (this.$refs.adminPasswordInput != null) {
				this.$refs.adminPasswordInput.focus()
			}
		})
	}

	this.dbDone = function () {
		this.dbRequesting = false
	}

	this.goBackAPI = function () {
		this.step = this.STEP_API
	}

	this.goDBNext = function () {
		this.step = this.STEP_ADMIN
	}

	// 管理员
	this.goBackDB = function () {
		this.step = this.STEP_DB
	}

	this.adminInfo = {}
	this.adminPassword = ""
	this.adminPassword2 = ""
	this.adminPasswordVisible = false

	this.showAdminPassword = function () {
		this.adminPasswordVisible = !this.adminPasswordVisible

		// TODO 切换密码显示的时候应该focus输入框
	}

	this.adminSuccess = function (resp) {
		this.step = this.STEP_FINISH
		this.adminInfo = resp.data.admin
	}

	// 结束
	this.goBackAdmin = function () {
		this.step = this.STEP_ADMIN
	}

	this.isInstalling = false
	this.finishSubmit = function () {
		this.isInstalling = true
	}

	this.finishDone = function () {
		this.isInstalling = false
	}

	this.finishSuccess = function () {
		teaweb.success("html:恭喜你！安装完成！<br/>请记住你创建的管理员账号，现在跳转到登录界面。", function () {
			window.location = "/"
		})
	}

	this.statusText = ""
	this.loadStatusText = function () {
		if (!this.isInstalling) {
			this.statusText = ""
			this.$delay(function () {
				this.loadStatusText()
			}, 1000)
			return
		}
		this.$post(".status")
			.success(function (resp) {
				this.statusText = resp.data.statusText
			})
			.done(function () {
				this.$delay(function () {
					this.loadStatusText()
				}, 1000)
			})
	}

	/**
	 * MySQL
	 */
	this.installMySQL = function () {
		let that = this
		teaweb.popup("/setup/mysql/installPopup", {
			height: "28em",
			onClose: function () {
				that.detectDB()
			}
		})
	};

	this.teaTheme = 'theme11';
})

// from @layout.js
Vue.component('b-steps', {
	props: {
		steps: Array, // {label, key}[]
		current: String,
	},
	template: `
		<div class="b-steps">
			<template v-for="step, index in steps">
				<div class="step" :class="{
					current: step.key == current,
				}">
					<div class="number">
						{{index+1}}
					</div>
					<div class="label">
						{{step.label}}
					</div>
				</div>
				<div class="line" v-if="index < steps.length - 1"></div>
			</template>
		</div>
	`,
});
Vue.component('b-select', {
	props: {
		id: String,
		name: String,
		value: [String, Number],
		options: Array, // {label, value}[]
		style: String,
		appendTo: {
			type: String,
			default: 'app'
		},
		autoWidth: {
			type: Boolean,
			default: false,
		},
		showFilter: {
			type: Boolean,
			default: false,
		},
	},
	data() {
		return {
			currentHoverIndex: -1,
			opened: false,
			filterText: '', // 添加过滤文本
			filteredOptions: [] // 添加过滤后的选项
		};
	},
	outsideClickListener: null,
	resizeListener: null,
	scrollHandler: null,
	watch: {
		options: {
			immediate: true,
			handler(val) {
				this.filteredOptions = val;
			}
		},
		filterText(val) {
			if(!val) {
				this.filteredOptions = this.options;
				return;
			}
			this.filteredOptions = this.options.filter(option => {
				if(option.type === 'header') return true;
				return option.label.toLowerCase().includes(val.toLowerCase());
			});
		}
	},
	methods: {
		handleItemClick(option) {
			this.$emit('input', option.value);
			this.$emit('change', option.value);
			this.opened = false;
			this.filterText = '';
		},
		handleOpen() {
			this.opened = !this.opened;
			if(!this.opened) {
				this.filterText = '';
			}
		},
		documentClickHandle(e) {
			if (this.opened) {
				const target = e.target;
				if (target.closest('.b-select-container') && target.closest('.b-select-container').querySelector('.b-select-dropdown')) {
					return;
				}
				this.opened = false;
				this.filterText = '';
			}
		},
		onOverlayEnter() {
			this.$refs.overlay.style.zIndex = String(domhandler.generateZIndex());
			this.appendContainer();
			this.alignOverlay();
			this.bindOutsideClickListener();
			this.bindScrollListener();
			this.bindResizeListener();
			this.$emit('show');
			// 自动聚焦到过滤输入框
			this.$nextTick(() => {
				this.$refs.filterInput?.focus();
			});
		},
		onOverlayLeave() {
			this.unbindOutsideClickListener();
			this.unbindScrollListener();
			this.unbindResizeListener();
			this.$emit('hide');
			this.filterText = '';
		},
		show() {
			this.$emit('before-show');
			this.opened = true;
		},
		hide() {
			this.$emit('before-hide');
			this.opened = false;
			this.filterText = '';
		},
		bindOutsideClickListener() {
			if (!this.outsideClickListener) {
				this.outsideClickListener = (event) => {
					if (this.opened && this.isOutsideClicked(event)) {
						this.hide();
					}
				};
				document.addEventListener('click', this.outsideClickListener);
			}
		},
		unbindOutsideClickListener() {
			if (this.outsideClickListener) {
				document.removeEventListener('click', this.outsideClickListener);
				this.outsideClickListener = null;
			}
		},
		bindScrollListener() {
			if (!this.scrollHandler) {
				this.scrollHandler = new connectedoverlayscrollhandler(this.$el, () => {
					if (this.opened) {
						this.hide();
					}
				});
			}
			this.scrollHandler.bindScrollListener();
		},
		unbindScrollListener() {
			if (this.scrollHandler) {
				this.scrollHandler.unbindScrollListener();
			}
		},
		appendContainer() {
			if (this.appendTo) {
				if (this.appendTo === 'body'|| !document.getElementById(this.appendTo))
					document.body.appendChild(this.$refs.overlay);
				else
					document.getElementById(this.appendTo).appendChild(this.$refs.overlay);
			}
		},
		bindResizeListener() {
			if (!this.resizeListener) {
				this.resizeListener = () => {
					if (this.opened && !domhandler.isAndroid()) {
						this.hide();
					}
				};
				window.addEventListener('resize', this.resizeListener);
			}
		},
		unbindResizeListener() {
			if (this.resizeListener) {
				window.removeEventListener('resize', this.resizeListener);
				this.resizeListener = null;
			}
		},
		isOutsideClicked(event) {
			return !(this.$refs.container.isSameNode(event.target) || this.$refs.container.contains(event.target) || (this.$refs.overlay && this.$refs.overlay.contains(event.target)));
		},
		restoreAppend() {
			if (this.$refs.overlay && this.appendTo) {
				if (this.appendTo === 'body'|| !document.getElementById(this.appendTo))
					document.body.removeChild(this.$refs.overlay);
				else
					document.getElementById(this.appendTo).removeChild(this.$refs.overlay);
			}
		},
		alignOverlay() {
			if (this.appendTo) {
				domhandler.absolutePosition(this.$refs.overlay, this.$refs.container);
				this.$refs.overlay.style.minWidth = domhandler.getOuterWidth(this.$refs.container) + 'px';
			}
			else {
				domhandler.relativePosition(this.$refs.overlay, this.$refs.container);
			}
		},
	},
	mounted() {
		document.addEventListener('click', this.documentClickHandle);
	},
	beforeDestroy() {
		this.restoreAppend();
		this.unbindOutsideClickListener();
		this.unbindResizeListener();

		if (this.scrollHandler) {
			this.scrollHandler.destroy();
			this.scrollHandler = null;
		}
		document.removeEventListener('click', this.documentClickHandle);
	},
	template: `
		<div class="b-select-container" ref="container" :class="{
			'auto-width': autoWidth
		}" :style="style">
			<input type="hidden" :id="id" :name="name" :value="value" />
			<div class="b-select" @click.prevent.stop="handleOpen">
				<span>{{options.find(option=>option.value==value)?.label}}</span>
				<svg width="14" height="14" viewBox="0 0 14 14" stroke="none" xmlns="http://www.w3.org/2000/svg" class="p-icon p-select-dropdown-icon" aria-hidden="true" data-pc-section="dropdownicon"><path d="M7.01744 10.398C6.91269 10.3985 6.8089 10.378 6.71215 10.3379C6.61541 10.2977 6.52766 10.2386 6.45405 10.1641L1.13907 4.84913C1.03306 4.69404 0.985221 4.5065 1.00399 4.31958C1.02276 4.13266 1.10693 3.95838 1.24166 3.82747C1.37639 3.69655 1.55301 3.61742 1.74039 3.60402C1.92777 3.59062 2.11386 3.64382 2.26584 3.75424L7.01744 8.47394L11.769 3.75424C11.9189 3.65709 12.097 3.61306 12.2748 3.62921C12.4527 3.64535 12.6199 3.72073 12.7498 3.84328C12.8797 3.96582 12.9647 4.12842 12.9912 4.30502C13.0177 4.48162 12.9841 4.662 12.8958 4.81724L7.58083 10.1322C7.50996 10.2125 7.42344 10.2775 7.32656 10.3232C7.22968 10.3689 7.12449 10.3944 7.01744 10.398Z" fill="currentColor"></path></svg>
			</div>
			<transition @enter="onOverlayEnter" @leave="onOverlayLeave">
				<div ref="overlay" class="b-select-dropdown" v-if="opened">
					<div class="b-select-filter" v-if="showFilter">
						<input 
							ref="filterInput"
							type="text" 
							v-model="filterText"
							placeholder="输入关键字过滤..."
							@click.stop
						/>
					</div>
					<template v-for="option, index in filteredOptions">
						<div v-if="option.type==='header'" class="b-select-dropdown-header">
							{{option.label}}
						</div>
						<div v-else
							class="b-select-dropdown-item"
							:class="{
								current: option.value == value,
								hover: currentHoverIndex == index
							}"
							@click="handleItemClick(option)"
							@mouseenter="currentHoverIndex=index"
							@mouseleave="currentHoverIndex=-1"
						>
							{{option.label}}
						</div>
					</template>
					<div v-if="filteredOptions.length === 0" class="b-select-no-results">
						没有匹配的选项
					</div>
				</div>
			</transition>
		</div>
	`,
});

Vue.component('b-settings-header', {
	props: {
		actionText: String,
		subTitle: String,
		href: String,
	},
	template: `
		<h3 class="b-settings-header">
			<span class="title"><slot></slot></span>
			<div class="sub-title" v-if="subTitle">{{subTitle}}</div>
			<a class="action" v-if="actionText && href" :href="href">
				{{actionText}}
			</a>
			<a class="action" v-if="actionText && !href" @click.prevent="$emit('action')">
				{{actionText}}
			</a>
		</h3>
	`,
});