Tea.context(function () {
	const t = this.t.bind(this)
	
	// 表格列定义
	this.columns = [
		{
			title: t('settings_user_nodes_index@节点名称'),
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' }
		},
		{
			title: t('settings_user_nodes_index@访问地址'),
			key: 'accessAddrs',
			scopedSlots: { customRender: 'addrSlot' },
			width: '300px'
		},
		{
			title: t('settings_user_nodes_index@版本号'),
			key: 'version',
			scopedSlots: { customRender: 'versionSlot' },
			width: '100px',
			align: 'center'
		},
		{
			title: 'CPU',
			key: 'cpu',
			scopedSlots: { customRender: 'cpuSlot' },
			width: '80px',
			align: 'center'
		},
		{
			title: t('settings_user_nodes_index@内存'),
			key: 'mem',
			scopedSlots: { customRender: 'memSlot' },
			width: '80px',
			align: 'center'
		},
		{
			title: t('settings_user_nodes_index@状态'),
			key: 'status',
			scopedSlots: { customRender: 'statusSlot' },
			width: '100px',
			align: 'center'
		},
		{
			title: t('settings_user_nodes_index@操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '150px',
			align: 'center'
		}
	];

	// 创建节点
	this.createNode = function () {
		teaweb.popup("/settings/userNodes/node/createPopup", {
			title: t('settings_user_nodes_index@添加用户节点'),
			width: "50em",
			height: "30em",
			callback: function () {
				teaweb.success(t("settings_user_nodes_index@保存成功"), function () {
					teaweb.reload()
				})
			}
		})
	}

	// 删除节点
	this.deleteNode = function (nodeId) {
		let that = this
		teaweb.confirm(t("settings_user_nodes_index@确定要删除此节点吗？"), function () {
			that.$post("/settings/userNodes/delete")
				.params({
					nodeId: nodeId
				})
				.refresh()
		})
	}
	
	// 加载节点数据的逻辑
	this.loadNodes = function() {
		this.isLoading = true;
		this.$post(".") // 假设当前路径是正确的后端API端点
			// .params({...}) // 可能需要的分页或过滤参数
			.success(function (resp) {
				this.nodes = resp.data.nodes || [];
				this.page = resp.data.page || null;
			})
			.done(function() {
				this.isLoading = false;
			});
	};

	// 初始化加载节点数据
	this.$delay(function () {
		this.loadNodes();
	});
	
	// 过滤分页内容 (需要添加或保留)
	this.filterPageContent = function(pageContent) {
		// 这里应该有处理分页HTML的逻辑
		return pageContent || ""; 
	};
})