Tea.context(function () {
	const t = this.t.bind(this)
	this.isGenerating = false

	this.columns = [
		{
			title: t('库文件生成时间'),
			dataIndex: 'generatedTime',
			key: 'generatedTime',
			width: '200px',
			scopedSlots: { customRender: 'timeSlot' }
		},
		{
			title: t('操作'),
			dataIndex: 'action',
			key: 'action',
			width: '300px',
			scopedSlots: { customRender: 'actionSlot' }
		}
	]
	this.generateLibrary = function (libraryFileId) {
		let that = this
		teaweb.confirm(t("确定要重新生成库文件吗？"), function () {
			that.isGenerating = true
			that.$post("/settings/ip-library/creating/generate")
				.params({
					libraryFileId: libraryFileId
				})
				.timeout(300)
				.success(function () {
					teaweb.successRefresh(t("生成成功"))
				})
				.done(function () {
					that.isGenerating = false
				})
		})
	}

	this.deleteLibrary = function (libraryFileId) {
		let that = this
		teaweb.confirm(t("html:确定要删除此库文件吗？"), function () {
			that.$post("/settings/ip-library/delete")
				.params({
					libraryFileId: libraryFileId
				})
				.success(function () {
					teaweb.successRefresh(t("删除成功"))
				})
		})
	}
})