Tea.context(function () {
	const t = this.t.bind(this)
	this.STEP_TEMPLATE = "template"
	this.STEP_UPLOAD = "upload"
	this.STEP_COUNTRY = "country"
	this.STEP_PROVINCE = "province"
	this.STEP_CITY = "city"
	this.STEP_TOWN = "town"
	this.STEP_PROVIDER = "provider"
	this.STEP_FINISH = "finish"

	this.step = this.STEP_TEMPLATE

	this.goStep = function (step) {
		this.step = step

		switch (step) {
			case this.STEP_UPLOAD:
				if (this.libraryFileId > 0) {
					this.goStep(this.STEP_COUNTRY)
				}
				break
			case this.STEP_COUNTRY:
				this.reloadCountries()
				break
			case this.STEP_PROVINCE:
				this.reloadProvinces()
				break
			case this.STEP_CITY:
				this.reloadCities()
				break
			case this.STEP_TOWN:
				this.reloadTowns()
				break
			case this.STEP_PROVIDER:
				this.reloadProviders()
				break
		}
	}

	this.$delay(function () {
		switch (this.step) {
			case this.STEP_TEMPLATE:
				setTimeout(() => {
					this.$refs.libraryName && this.$refs.libraryName.focus()
				}, 100)
				break
			case this.STEP_COUNTRY:
				this.isLoadingCountries = true
				this.reloadCountries()
				break
			case this.STEP_PROVINCE:
				this.isLoadingProvinces = true
				this.reloadProvinces()
				break
			case this.STEP_CITY:
				this.isLoadingCities = true
				this.reloadCities()
				break
			case this.STEP_TOWN:
				this.isLoadingTowns = true
				this.reloadTowns()
				break
			case this.STEP_PROVIDER:
				this.isLoadingProviders = true
				this.reloadProviders()
				break
		}
	})

	/**
	 * 数据格式
	 */
	this.rowTemplate = ""
	this.formatTestText = ""
	this.formatTestResult = ""
	this.password = ""

	this.libraryName = ""
	this.emptyValues = []

	this.libraryFileId = 0

	if (this.updatingLibraryFile != null) {
		this.libraryFileId = this.updatingLibraryFile.id
		this.rowTemplate = this.updatingLibraryFile.template
		this.libraryName = this.updatingLibraryFile.name
		if (this.updatingLibraryFile.emptyValues != null) {
			this.emptyValues = this.updatingLibraryFile.emptyValues
		}
	}

	this.formatIP2Region = function () {
		this.rowTemplate = "${ipFrom}|${ipTo}|${country}|${any}|${province}|${city}|${provider}"
	}

	this.formatIP138 = function () {
		this.rowTemplate = "${any},${any},${ipFrom},${ipTo},${country},${province},${city},${town},${provider},${any},${any},${any}"
	}

	this.testFormat = function () {
		this.$post("/settings/ip-library/creating/testFormat")
			.params({
				template: this.rowTemplate,
				text: this.formatTestText
			})
			.success(function (resp) {
				let values = resp.data.values
				let pieces = []
				if (values["country"] != null && values["country"].length > 0) {
					pieces.push(t("国家/地区") + "：" + values["country"])
				}
				if (values["province"] != null && values["province"].length > 0) {
					pieces.push(t("省份/州") + "：" + values["province"])
				}
				if (values["city"] != null && values["city"].length > 0) {
					pieces.push(t("城市/市") + "：" + values["city"])
				}
				if (values["town"] != null && values["town"].length > 0) {
					pieces.push(t("区县") + "：" + values["town"])
				}
				if (values["provider"] != null && values["provider"].length > 0) {
					pieces.push(t("ISP运营商") + "：" + values["provider"])
				}

				this.formatTestResult = pieces.join("；")
			})
	}

	this.changeFormatTestText = function () {
		this.formatTestResult = ""
	}

	this.templateGoNext = function () {
		if (this.libraryName.length == 0) {
			let that = this
			teaweb.warn(t("请输入IP库名字"), function () {
				that.$refs.libraryName.focus()
			})
			return
		}
		if (this.rowTemplate.length == 0) {
			let that = this
			teaweb.warn(t("请先输入数据格式模板"), function () {
				that.$refs.rowTemplate.focus()
			})
			return
		}
		this.goStep(this.STEP_UPLOAD)
	}

	/**
	 * 上传
	 */
	this.isUploading = false

	this.upload = function () {
		let dataFile = this.$refs.dataFile
		if (dataFile.files.length == 0) {
			teaweb.warn(t("请先上传文件"))
			return
		}

		this.isUploading = true

		let emptyValues = this.$refs.emptyValues.allValues()

		this.$post("/settings/ip-library/creating/upload")
			.timeout(300)
			.params({
				name: this.libraryName,
				template: this.rowTemplate,
				file: dataFile.files[0],
				emptyValues: emptyValues,
				password: this.password
			})
			.success(function (resp) {
				this.libraryFileId = resp.data.libraryFileId
				let that = this
				teaweb.success(t("上传成功"), function () {
					that.step = that.STEP_COUNTRY
					that.reloadCountries()
				})
			})
			.error(function () {
				teaweb.warn(t("操作超时，可能是网络太慢"))
			})
			.done(function () {
				this.isUploading = false
			})
	}

	/**
	 * 国家
	 */
	this.missingCountries = []
	this.missingCountriesLoaded = false
	this.isLoadingCountries = false
	this.countryColumns = [
		{
			title: t('国家/地区'),
			dataIndex: 'countryName',
			key: 'countryName',
			width: '30%'
		},
		{
			title: t('问题'),
			key: 'problem',
			scopedSlots: { customRender: 'problemSlot' }
		}
	]
	this.reloadCountries = function () {
		this.isLoadingCountries = true
		this.missingCountriesLoaded = false
		this.$post("/settings/ip-library/creating/countries")
			.params({
				"libraryFileId": this.libraryFileId
			})
			.success(function (resp) {
				this.missingCountries = resp.data.missingCountries
			})
			.done(function () {
				this.missingCountriesLoaded = true
				this.isLoadingCountries = false
			})
	}

	this.addCountryCustomCode = function (country, code) {
		let that = this
		teaweb.confirm(t("加入别名Tips", [teaweb.encodeHTML(code), teaweb.encodeHTML(country.displayName)]), function () {
			that.$post("/settings/ip-library/creating/addCountryCustomCode")
				.params({
					countryId: country.id,
					code: code
				})
				.success(function () {
					teaweb.success(t("操作成功"), function () {
						that.reloadCountries()
					})
				})
		})
	}

	/**
	 * 省
	 */
	this.missingProvinces = []
	this.missingProvincesLoaded = false
	this.isLoadingProvinces = false
	this.provinceColumns = [
		{
			title: t('国家/地区'),
			dataIndex: 'countryName',
			key: 'countryName',
		},
		{
			title: t('省份/州'),
			dataIndex: 'provinceName',
			key: 'provinceName',
			width: '200px'
		},
		{
			title: t('问题'),
			key: 'problem',
			scopedSlots: { customRender: 'problemSlot' }
		}
	]
	this.reloadProvinces = function () {
		this.isLoadingProvinces = true
		this.missingProvincesLoaded = false
		this.$post("/settings/ip-library/creating/provinces")
			.params({
				"libraryFileId": this.libraryFileId
			})
			.success(function (resp) {
				this.missingProvinces = resp.data.missingProvinces
			})
			.done(function () {
				this.missingProvincesLoaded = true
				this.isLoadingProvinces = false
			})
	}

	this.addProvinceCustomCode = function (province, code) {
		let that = this
		teaweb.confirm(t("加入别名Tips", [teaweb.encodeHTML(code), teaweb.encodeHTML(province.displayName)]), function () {
			that.$post("/settings/ip-library/creating/addProvinceCustomCode")
				.params({
					provinceId: province.id,
					code: code
				})
				.success(function () {
					teaweb.success(t("操作成功"), function () {
						that.reloadProvinces()
					})
				})
		})
	}

	/**
	 * 市
	 */
	this.missingCities = []
	this.missingCitiesLoaded = false
	this.isLoadingCities = false
	this.sizePerPage = 100
	this.cityColumns = [
		{
			title: t('国家/地区'),
			dataIndex: 'countryName',
			key: 'countryName',
			width: '150px'
		},
		{
			title: t('省份/州'),
			dataIndex: 'provinceName',
			key: 'provinceName',
			width: '150px'
		},
		{
			title: t('城市/市'),
			dataIndex: 'cityName',
			key: 'cityName',
			width: '150px'
		},
		{
			title: t('问题'),
			key: 'problem',
			scopedSlots: { customRender: 'problemSlot' }
		}
	]
	this.reloadCities = function () {
		this.isLoadingCities = true
		this.missingCitiesLoaded = false
		this.$post("/settings/ip-library/creating/cities")
			.params({
				libraryFileId: this.libraryFileId,
				size: this.sizePerPage
			})
			.success(function (resp) {
				this.missingCities = resp.data.missingCities
			})
			.done(function () {
				this.missingCitiesLoaded = true
				this.isLoadingCities = false
			})
	}

	this.addCityCustomCode = function (city, code) {
		let that = this
		teaweb.confirm(t("加入别名Tips", [teaweb.encodeHTML(code), teaweb.encodeHTML(city.displayName)]), function () {
			that.$post("/settings/ip-library/creating/addCityCustomCode")
				.params({
					cityId: city.id,
					code: code
				})
				.success(function () {
					teaweb.success(t("操作成功"), function () {
						that.reloadCities()
					})
				})
		})
	}

	/**
	 * 县
	 */
	this.missingTowns = []
	this.missingTownsLoaded = false
	this.isLoadingTowns = false
	this.townColumns = [
		{
			title: t('国家/地区'),
			dataIndex: 'countryName',
			key: 'countryName',
			width: '150px'
		},
		{
			title: t('省份/州'),
			dataIndex: 'provinceName',
			key: 'provinceName',
			width: '150px'
		},
		{
			title: t('城市/市'),
			dataIndex: 'cityName',
			key: 'cityName',
			width: '150px'
		},
		{
			title: t('区/县'),
			dataIndex: 'townName',
			key: 'townName',
			width: '150px'
		},
		{
			title: t('问题'),
			key: 'problem',
			scopedSlots: { customRender: 'problemSlot' }
		}
	]
	this.reloadTowns = function () {
		this.isLoadingTowns = true
		this.missingTownsLoaded = false
		this.$post("/settings/ip-library/creating/towns")
			.params({
				"libraryFileId": this.libraryFileId
			})
			.success(function (resp) {
				this.missingTowns = resp.data.missingTowns
			})
			.done(function () {
				this.missingTownsLoaded = true
				this.isLoadingTowns = false
			})
	}

	this.addTownCustomCode = function (town, code) {
		let that = this
		teaweb.confirm(t("加入别名Tips", [teaweb.encodeHTML(code), teaweb.encodeHTML(town.displayName)]), function () {
			that.$post("/settings/ip-library/creating/addTownCustomCode")
				.params({
					townId: town.id,
					code: code
				})
				.success(function () {
					teaweb.success(t("操作成功"), function () {
						that.reloadTowns()
					})
				})
		})
	}

	/**
	 * ISP
	 */
	this.missingProviders = []
	this.missingProvidersLoaded = false
	this.isLoadingProviders = false
	this.providerColumns = [
		{
			title: t('ISP运营商'),
			dataIndex: 'providerName',
			key: 'providerName',
			width: '300px'
		},
		{
			title: t('问题'),
			key: 'problem',
			scopedSlots: { customRender: 'problemSlot' }
		}
	]
	this.reloadProviders = function () {
		this.isLoadingProviders = true
		this.missingProvidersLoaded = false
		this.$post("/settings/ip-library/creating/providers")
			.params({
				"libraryFileId": this.libraryFileId
			})
			.success(function (resp) {
				this.missingProviders = resp.data.missingProviders
			})
			.done(function () {
				this.missingProvidersLoaded = true
				this.isLoadingProviders = false
			})
	}

	this.addProviderCustomCode = function (provider, code) {
		let that = this
		teaweb.confirm(t("html:确定要将 \"<strong>{0}</strong>\" 加入到 \"<strong>{1}</strong>\" 别名中吗？<br/>请再三确认无误后，才进行确定操作！", teaweb.encodeHTML(code), teaweb.encodeHTML(provider.displayName)), function () {
			that.$post("/settings/ip-library/creating/addProviderCustomCode")
				.params({
					providerId: provider.id,
					code: code
				})
				.success(function () {
					teaweb.success(t("操作成功"), function () {
						that.reloadProviders()
					})
				})
		})
	}

	/**
	 * 完成
	 */
	this.isFinishing = false

	this.finish = function () {
		let that = this
		teaweb.confirm(t("标记完成Tips"), function () {
			that.isFinishing = true
			that.$post("/settings/ip-library/creating/finish")
				.params({
					libraryFileId: this.libraryFileId
				})
				.timeout(300)
				.success(function () {
					teaweb.success(t("保存成功"), function () {
						window.location = "/settings/ip-library"
					})
				})
				.done(function () {
					that.isFinishing = false
				})
		})
	}
})