Tea.context(function () {
	const t = this.t.bind(this)
	this.teaweb = teaweb

	// 表格列定义
	this.columns = [
		{
			title: t('IP库名称'),
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' }
		},
		{
			title: t('IP库类型'),
			key: 'type',
			scopedSlots: { customRender: 'typeSlot' },
			width: '150px'
		},
		{
			title: t('代号'),
			dataIndex: 'code',
			key: 'code',
			width: '150px'
		},
		{
			title: t('尺寸'),
			key: 'size',
			scopedSlots: { customRender: 'sizeSlot' },
			width: '120px',
			align: 'right' // 尺寸右对齐可能更好看
		},
		{
			title: t('下载'),
			key: 'download',
			scopedSlots: { customRender: 'downloadSlot' },
			width: '80px',
			align: 'center'
		},
		{
			title: t('是否正在使用'),
			key: 'isPublic',
			scopedSlots: { customRender: 'publicSlot' },
			width: '150px',
			align: 'center'
		},
		{
			title: t('操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '200px', // 操作按钮较多，给宽一点
			align: 'center'
		}
	];

	this.deleteArtifact = function (artifactId,artifactType) {
		let that = this
		teaweb.confirm(t('确定要删除此IP库吗？'), function () {
			that.$post("/settings/ip-library/delete")
				.params({
					artifactId: artifactId,
					artifactType: artifactType
				})
				.success(function () {
					teaweb.successRefresh(t('删除成功'))
				})
		})
	}

	this.updateArtifactPublic = function (artifactId, isPublic, artifactType) {
		let that = this
		let message = t('确定要使用当前IP库吗？')
		if (!isPublic) {
			message = t('确定要取消使用当前IP库吗？')
		}
		teaweb.confirm(message, function () {
			that.$post("/settings/ip-library/updatePublic")
				.params({
					artifactId: artifactId,
					isPublic: isPublic ? 1 : 0,
					artifactType: artifactType
				})
				.success(function () {
					if (isPublic) {
						teaweb.successRefresh(t('使用成功，将在10分钟内生效'))
					} else {
						teaweb.successRefresh(t('取消成功，将在10分钟内生效'))
					}
				})
		})
	}
})