Tea.context(function () {
	const t = this.t.bind(this)
	// 表格列定义
	this.columns = [
		{
			title: t('settings_db_nodes_index@节点名称'),
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' }
		},
		{
			title: t('settings_db_nodes_index@数据库引擎'),
			dataIndex: 'dbEngine',
			key: 'dbEngine',
			width: '120px'
		},
		{
			title: t('settings_db_nodes_index@连接地址'),
			key: 'addr',
			scopedSlots: { customRender: 'addrSlot' },
			width: '200px'
		},
		{
			title: t('settings_db_nodes_index@数据库名'),
			dataIndex: 'database',
			key: 'database',
			width: '150px'
		},
		{
			title: t('settings_db_nodes_index@数据库版本'),
			key: 'version',
			scopedSlots: { customRender: 'versionSlot' },
			width: '120px',
			align: 'center'
		},
		{
			title: t('settings_db_nodes_index@用量'),
			key: 'size',
			scopedSlots: { customRender: 'sizeSlot' },
			width: '100px',
			align: 'center'
		},
		{
			title: t('settings_db_nodes_index@状态'),
			key: 'status',
			scopedSlots: { customRender: 'statusSlot' },
			width: '120px',
			align: 'center'
		},
		{
			title: t('settings_db_nodes_index@操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '150px',
			align: 'center'
		}
	];
	
	// 添加节点
	this.createNode = function () {
		teaweb.popup("/settings/db-nodes/createPopup", {
			title: t('settings_db_nodes_index@添加节点'),
			height: "30em",
			callback: function () {
				teaweb.success(t("settings_db_nodes_index@保存成功"), function () {
					window.location.reload()
				})
			}
		})
	}

	// 删除节点
	this.deleteNode = function (nodeId) {
		let that = this
		teaweb.confirm(t("settings_db_nodes_index@确定要删除此数据库节点吗？"), function () {
			that.$post(".delete")
				.params({
					nodeId: nodeId
				})
				.refresh()
		})
	}
	
	// 显示错误信息
	this.showError = function (err) {
		teaweb.popupTip("<span style=\"color:#db2828\">" + t("settings_db_nodes_index@错误信息：") + err + "</span>")
	}
})