Tea.context(function () {
    this.tables = []
    this.isLoading = true
    const t = this.t.bind(this)

    this.$delay(function () {
        this.reload()
    })

    this.reload = function () {
        this.isLoading = true
        this.$post("$")
            .params({ nodeId: this.nodeId })
            .success(function (resp) {
                this.tables = resp.data.tables;
            })
            .done(function () {
                this.isLoading = false
            })
    }

    this.deleteTable = function (tableName) {
        let that = this
        teaweb.confirm("html:" + t("settings_db_nodes_clean@确定要删除此数据表吗？") + "<br/>" + t("settings_db_nodes_clean@删除后数据不能恢复！"), function () {
            that.$post(".deleteTable")
                .params({
                    nodeId: that.nodeId,
                    table: tableName
                })
                .success(function () {
                    teaweb.success(t("settings_db_nodes_clean@操作成功"), function () {
                        that.reload()
                    })
                })
        })
    }

    this.truncateTable = function (tableName) {
        let that = this
        teaweb.confirm("html:" + t("settings_db_nodes_clean@确定要清空此数据表吗？") + "<br/>" + t("settings_db_nodes_clean@清空后数据不能恢复！"), function () {
            that.$post(".truncateTable")
                .params({
                    nodeId: that.nodeId,
                    table: tableName
                })
                .success(function () {
                    teaweb.success(t("settings_db_nodes_clean@操作成功"), function () {
                        that.reload()
                    })
                })
        })
    }
})