Tea.context(function () {
    const t = this.t.bind(this)
    this.tables = []
    this.isLoading = true

    this.$delay(function () {
        this.reload()
    })

    this.reload = function () {
        this.isLoading = true
        this.$post("$")
			.params({
				orderTable: this.orderTable,
				orderSize: this.orderSize
			})
            .success(function (resp) {
                this.tables = resp.data.tables;
            })
            .done(function () {
                this.isLoading = false
            })
    }

    this.deleteTable = function (tableName) {
        let that = this
        teaweb.confirm("html:" + t("settings_database_clean@确定要删除此数据表吗？") + "<br/>" + t("settings_database_clean@删除后数据不能恢复！"), function () {
            that.$post(".deleteTable")
                .params({
                    table: tableName
                })
                .success(function () {
                    teaweb.success(t("settings_database_clean@操作成功"), function () {
                        that.reload()
                    })
                })
        })
    }

    this.truncateTable = function (tableName) {
        let that = this
        teaweb.confirm("html:" + t("settings_database_clean@确定要清空此数据表吗？") + "<br/>" + t("settings_database_clean@清空后数据不能恢复！"), function () {
            that.$post(".truncateTable")
                .params({
                    table: tableName
                })
                .success(function () {
                    teaweb.success(t("settings_database_clean@操作成功"), function () {
                        that.reload()
                    })
                })
        })
    }

    this.columns = [
        {
            title: t('settings_database_clean@数据表名'),
            dataIndex: 'name',
            key: 'name',
        },
        {
            title: t('settings_database_clean@占用空间'),
            dataIndex: 'size',
            key: 'size',
            scopedSlots: { customRender: 'sizeSlot' },
        },
        {
            title: t('settings_database_clean@用途'),
            dataIndex: 'comment',
            key: 'comment'
        },
        {
            title: t('settings_database_clean@操作'),
            key: 'action',
            scopedSlots: { customRender: 'actionSlot' },
            width: '150px', // 可以指定宽度
            align: 'center'
        }
    ]
})