Tea.context(function () {
	const t = this.t.bind(this)
	
	// 表格列定义
	this.columns = [
		{
			title: t('settings_api_index@节点名称'),
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' }
		},
		{
			title: t('settings_api_index@GRPC访问地址'),
			key: 'grpc',
			scopedSlots: { customRender: 'grpcSlot' },
			width: '200px'
		},
		{
			title: t('settings_api_index@HTTP访问地址'),
			key: 'http',
			scopedSlots: { customRender: 'httpSlot' },
			width: '200px'
		},
		{
			title: t('settings_api_index@版本号'),
			key: 'version',
			scopedSlots: { customRender: 'versionSlot' },
			width: '100px',
			align: 'center'
		},
		{
			title: 'CPU',
			key: 'cpu',
			scopedSlots: { customRender: 'cpuSlot' },
			width: '80px',
			align: 'center'
		},
		{
			title: t('settings_api_index@内存'),
			key: 'mem',
			scopedSlots: { customRender: 'memSlot' },
			width: '80px',
			align: 'center'
		},
		{
			title: t('settings_api_index@状态'),
			key: 'status',
			scopedSlots: { customRender: 'statusSlot' },
			width: '100px',
			align: 'center'
		},
		{
			title: t('settings_api_index@操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '150px',
			align: 'center'
		}
	];

	// 创建节点
	this.createNode = function () {
		teaweb.popup(".node.createPopup", {
			title: t("settings_api_index@创建节点"),
			width: "50em",
			height: "30em",
			callback: function () {
				teaweb.success(t("settings_api_index@保存成功"), function () {
					teaweb.reload()
				})
			}
		})
	}

	// 删除节点
	this.deleteNode = function (nodeId) {
		let that = this
		teaweb.confirm(t("settings_api_index@确定要删除此节点吗？"), function () {
			that.$post(".delete")
				.params({
					nodeId: nodeId
				})
				.refresh()
		})
	}

	// 升级节点
	this.upgradeNode = function (nodeId) {
		teaweb.popup(".node.upgradePopup?nodeId=" + nodeId, {
			onClose: function () {
				teaweb.reload()
			}
		})
	}

	// 加载节点数据的逻辑 (需要添加)
	this.loadNodes = function() {
		this.isLoading = true;
		this.$post(".") // 假设当前路径是正确的后端API端点
			// .params({...}) // 可能需要的分页或过滤参数
			.success(function (resp) {
				this.nodes = resp.data.nodes || [];
				this.page = resp.data.page || null;
				this.hasMethodStats = resp.data.hasMethodStats || false;
			})
			.done(function() {
				this.isLoading = false;
			});
	};

	// 初始化加载节点数据
	this.$delay(function () {
		this.loadNodes();
	});
	
	// 过滤分页内容 (需要添加或保留)
	this.filterPageContent = function(pageContent) {
		// 这里应该有处理分页HTML的逻辑，或者直接返回
		// 如果后端返回的是结构化分页数据，这里可能不需要
		return pageContent || ""; 
	};
})