Tea.context(function () {
	this.$delay(function () {
		let that = this

		this.reloadRequestsChart("daily-requests-chart", this.$t('index_请求数统计_0101'), this.dailyStats, function (args) {
			if (args.seriesIndex == 0) {
				return that.dailyStats[args.dataIndex].day + " " + this.$t('index_请求数_0101') + ": " + teaweb.formatNumber(that.dailyStats[args.dataIndex].countRequests)
			}
			if (args.seriesIndex == 1) {
				let ratio = 0
				if (that.dailyStats[args.dataIndex].countRequests > 0) {
					ratio = Math.round(that.dailyStats[args.dataIndex].countCachedRequests * 10000 / that.dailyStats[args.dataIndex].countRequests) / 100
				}
				return that.dailyStats[args.dataIndex].day + " " + this.$t('index_缓存请求数_0101') + ": " + teaweb.formatNumber(that.dailyStats[args.dataIndex].countCachedRequests) + ", " + this.$t('index_命中率_0101') + ": " + ratio + "%"
			}
			return ""
		})
		this.reloadTrafficChart("daily-traffic-chart", "流量统计", this.dailyStats, function (args) {
			if (args.seriesIndex == 0) {
				return that.dailyStats[args.dataIndex].day + " " + this.$t('index_流量_0101') + ": " + teaweb.formatBytes(that.dailyStats[args.dataIndex].bytes)
			}
			if (args.seriesIndex == 1) {
				let ratio = 0
				if (that.dailyStats[args.dataIndex].bytes > 0) {
					ratio = Math.round(that.dailyStats[args.dataIndex].cachedBytes * 10000 / that.dailyStats[args.dataIndex].bytes) / 100
				}
				return that.dailyStats[args.dataIndex].day + " " + this.$t('index_缓存流量_0101') + ": " + teaweb.formatBytes(that.dailyStats[args.dataIndex].cachedBytes) + ", " + this.$t('index_命中率_0101') + ": " + ratio + "%"
			}
			return ""
		})
	})

	this.reloadRequestsChart = function (chartId, name, stats, tooltipFunc) {
		let chartBox = document.getElementById(chartId)
		if (chartBox == null) {
			return
		}

		let axis = teaweb.countAxis(stats, function (v) {
			return Math.max(v.countRequests, v.countCachedRequests)
		})

		let chart = teaweb.initChart(chartBox)
		let option = {
			xAxis: {
				data: stats.map(function (v) {
					return v.day.substr(5)
				})
			},
			yAxis: {
				axisLabel: {
					formatter: function (value) {
						return value + axis.unit
					}
				}
			},
			tooltip: {
				show: true,
				trigger: "item",
				backgroundColor: getCssVariable('--color-bg', '#app'),
				borderColor: getCssVariable('--color-border', '#app'),
				textStyle: {
					color: getCssVariable('--color-text-active', '#app'),
				},
				formatter: tooltipFunc,
			},
			grid: {
				left: 50,
				top: 40,
				right: 20,
				bottom: 20
			},
			series: [
				{
					name: this.$t('index_请求数_0101'),
					type: "line",
					data: stats.map(function (v) {
						return v.countRequests / axis.divider
					}),
					itemStyle: {
						color: getCssVariable('--color-text-active', '#'+chartId),
					},
					lineStyle: {
						color: getCssVariable('--color-text-active', '#'+chartId),
					},
					areaStyle: {
						color: getCssVariable('--color-text-active', '#'+chartId),
					},
					smooth: true
				},
				{
					name: this.$t('index_缓存请求数_0101'),
					type: "line",
					data: stats.map(function (v) {
						return v.countCachedRequests / axis.divider
					}),
					itemStyle: {
						color: "#61A0A8"
					},
					areaStyle: {
						color: "#61A0A8"
					},
					smooth: true
				}
			],
			legend: {
				data: [this.$t('index_请求数_0101'), this.$t('index_缓存请求数_0101')],
				textStyle: {
					color: getCssVariable('--color-text'),
				},
			},
			animation: true
		}
		chart.setOption(option)
		chart.resize()
	}

	this.reloadTrafficChart = function (chartId, name, stats, tooltipFunc) {
		let chartBox = document.getElementById(chartId)
		if (chartBox == null) {
			return
		}

		let axis = teaweb.bytesAxis(stats, function (v) {
			return Math.max(v.bytes, v.cachedBytes)
		})

		let chart = teaweb.initChart(chartBox)
		let option = {
			xAxis: {
				data: stats.map(function (v) {
					return v.day.substr(5)
				})
			},
			yAxis: {
				axisLabel: {
					formatter: function (value) {
						return value + axis.unit
					}
				}
			},
			tooltip: {
				show: true,
				trigger: "item",
				backgroundColor: getCssVariable('--color-bg', '#app'),
				borderColor: getCssVariable('--color-border', '#app'),
				textStyle: {
					color: getCssVariable('--color-text-active', '#app'),
				},
				formatter: tooltipFunc,
			},
			grid: {
				left: 50,
				top: 40,
				right: 20,
				bottom: 20
			},
			series: [
				{
					name: this.$t('index_流量_0101'),
					type: "line",
					data: stats.map(function (v) {
						return v.bytes / axis.divider
					}),
					itemStyle: {
						// color: teaweb.DefaultChartColor
						color: getCssVariable('--color-text-active', '#'+chart.getDom().id),
					},
					areaStyle: {
						// color: teaweb.DefaultChartColor
						color: getCssVariable('--color-text-active', '#'+chart.getDom().id),
					},
					smooth: true
				},
				{
					name: this.$t('index_缓存流量_0101'),
					type: "line",
					data: stats.map(function (v) {
						return v.cachedBytes / axis.divider
					}),
					itemStyle: {
						color: "#61A0A8"
					},
					areaStyle: {
						color: "#61A0A8"
					},
					smooth: true
				}
			],
			legend: {
				data: [this.$t('index_流量_0101'), this.$t('index_缓存流量_0101')],
				textStyle: {
					color: getCssVariable('--color-text'),
				},
			},
			animation: true
		}
		chart.setOption(option)
		chart.resize()
	}
})
