Tea.context(function () {
	const t = this.t.bind(this)
	// 表格列定义
	this.groupsColumns = [
		{
			title: "",
			width: "3em",
			dataIndex: "handle",
			key: "handle",
			scopedSlots: { customRender: "handleSlot" },
			className: "drag-handle"
		},
		{
			title: t('waf_groups@规则分组'),
			dataIndex: "name",
			key: "name",
			scopedSlots: { customRender: "nameSlot" }
		},
		{
			title: t('waf_groups@规则集'),
			dataIndex: "countSets",
			key: "countSets",
			scopedSlots: { customRender: "countSetsSlot" },
			width: "100px",
			align: "center"
		},
		{
			title: t('waf_groups@操作'),
			key: "action",
			scopedSlots: { customRender: "actionSlot" },
			width: "150px"
		}
	]

	// 排序处理
	this.sortGroups = function (groupIds) {
		let that = this
		this.$post("/servers/components/waf/sortGroups")
			.params({
				firewallPolicyId: that.firewallPolicyId,
				type: that.type,
				groupIds: groupIds
			})
			.success(function () {
				teaweb.successToast(t('waf_groups@排序保存成功'))
			})
	}

	// 启用
	this.enableGroup = function (groupId) {
		this.$post("/servers/components/waf/updateGroupOn")
			.params({
				groupId: groupId,
				isOn: 1
			})
			.refresh()

	}

	// 停用
	this.disableGroup = function (groupId) {
		this.$post("/servers/components/waf/updateGroupOn")
			.params({
				groupId: groupId,
				isOn: 0
			})
			.refresh()
	}

	// 删除
	this.deleteGroup = function (groupId) {
		let that = this
		teaweb.confirm(t('waf_groups@确定要删除此规则分组吗'), function () {
			that.$post("/servers/components/waf/deleteGroup")
				.params({
					firewallPolicyId: that.firewallPolicyId,
					groupId: groupId
				})
				.refresh()
		})
	}

	// 添加分组
	this.createGroup = function (type) {
		let that = this
		teaweb.popup("/servers/components/waf/createGroupPopup?firewallPolicyId=" + this.firewallPolicyId + "&type=" + type, {
			title: t('waf_groups@添加分组PopupTitle'),
			callback: function () {
				teaweb.success(t('waf_groups@保存成功'), function () {
					window.location.reload()
				})
			}
		})
	}
})