Tea.context(function () {
	this.bodyType = this.bodyTypes[0].code
	this.statusCode = ""
	this.codes = ['400', '401', '403', '404', '409', '419', '500', '502', '503']

	this.addHTMLTemplate = function () {
		// 获取当前状态码
		var statusCode = this.statusCode

		// 如果状态码为空，使用默认模板
		if (!statusCode) {
			this.setDefaultTemplate()
			return
		}

		// 尝试从error_pages目录加载对应状态码的模板
		this.loadErrorPageTemplate(statusCode)
	}

	function fetchErrorPageTemplate(statusCode) {
		// 使用 Date.now() 作为查询参数，防止浏览器缓存旧的语言文件
		const url = '/js/error_pages/' + statusCode + '.html?v=' + Date.now();
		const xhr = new XMLHttpRequest();
		// 第三个参数设置为 false，明确指示进行同步请求
		xhr.open('GET', url, false);
		try {
			xhr.send(null);
			// 检查 HTTP 状态码，确保请求成功 (2xx 范围)
			if (xhr.status >= 200 && xhr.status < 300) {
				// 解析 JSON 响应体
				return xhr.responseText;
			} else {
				// 如果加载失败，在控制台打印错误信息，并返回空对象，防止程序崩溃
				return null;
			}
		} catch (e) {
			// 如果请求过程中发生网络错误或 JSON 解析错误，打印错误信息，并返回空对象
			return null;
		}
	}

	// 加载错误页面模板
	this.loadErrorPageTemplate = function (statusCode) {
		var self = this
		var template = fetchErrorPageTemplate(statusCode)
		if (template) {
			self.$refs.htmlBody.value = template
		} else {
			self.setDefaultTemplate()
		}
	}

	// 设置默认模板
	this.setDefaultTemplate = function () {
		this.$refs.htmlBody.value = `<!DOCTYPE html>
<html lang="en">
<head>
\t<title>\${status} \${statusMessage}</title>
\t<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
\t<style>
\t\taddress { line-height: 1.8; }
\t</style>
</head>
<body>

<h1>\${status} \${statusMessage}</h1>
<p><!-- 内容 --></p>

<address>Connection: \${remoteAddr} (Client) -&gt; \${serverAddr} (Server)</address>
<address>Request ID: \${requestId}</address>

</body>
</html>`
	}

	this.exceptURLPatterns = []
	this.onlyURLPatterns = []
})