Tea.context(function () {
	this.addrError = ""
	const t = this.t.bind(this)
	this.isOSS = this.origin != null && this.origin.protocol != null && this.origin.protocol.startsWith("oss:")

	// 预先设置oss选项
	if (!this.isOSS) {
		this.origin.oss = {
			type: "",
			options: {}
		}
	}

	this.$delay(function () {
		this.checkPort()
	})

	// 验证地址格式（使用正则）
	this.validateAddr = function(addr) {
		if (!addr || addr.trim() === "") {
			return t('源站地址不能为空')
		}

		addr = addr.trim()
		
		// 移除协议前缀
		var cleanAddr = addr.replace(/^https?:\/\//, '')
		
		// IP地址正则：包含端口的完整格式
		var ipWithPortRegex = /^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(:[1-9][0-9]{0,4})?$/
		
		// 域名正则：包含端口的完整格式
		var domainWithPortRegex = /^[a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?(\.[a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?)*(\.[a-zA-Z]{2,})(:[1-9][0-9]{0,4})?$/
		
		// 简单IP地址正则：不含端口
		var simpleIpRegex = /^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/
		
		// 简单域名正则：不含端口
		var simpleDomainRegex = /^[a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?(\.[a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?)*(\.[a-zA-Z]{2,})$/

		if (!ipWithPortRegex.test(cleanAddr) && !domainWithPortRegex.test(cleanAddr) && 
			!simpleIpRegex.test(cleanAddr) && !simpleDomainRegex.test(cleanAddr)) {
			return t('源站地址格式不正确，请输入有效的IP地址或域名')
		}

		return ""
	}

	// 验证权重（使用正则）
	this.validateWeight = function(weight) {
		if (!weight || weight.toString().trim() === "") {
			return t('权重不能为空')
		}

		// 正整数正则：1-1000
		var weightRegex = /^([1-9]|[1-9][0-9]|[1-9][0-9][0-9]|1000)$/
		
		if (!weightRegex.test(weight.toString().trim())) {
			return t('权重必须是1-1000之间的整数')
		}

		return ""
	}

	// 验证超时时间（使用正则）
	this.validateTimeout = function(timeout, fieldName) {
		if (!timeout || timeout.toString().trim() === "") {
			return ""  // 允许为空
		}

		// 非负整数正则：0-3600
		var timeoutRegex = /^(0|[1-9][0-9]{0,3})$/
		var timeoutNum = parseInt(timeout.toString().trim())
		
		if (!timeoutRegex.test(timeout.toString().trim()) || timeoutNum > 3600) {
			return fieldName + t('必须是0-3600之间的整数')
		}

		return ""
	}

	// 验证连接数（使用正则）
	this.validateConnCount = function(count, fieldName) {
		if (!count || count.toString().trim() === "") {
			return ""  // 允许为空
		}

		// 非负整数正则：0-100000
		var countRegex = /^(0|[1-9][0-9]{0,5})$/
		var countNum = parseInt(count.toString().trim())
		
		if (!countRegex.test(count.toString().trim()) || countNum > 100000) {
			return fieldName + t('必须是0-100000之间的整数')
		}

		return ""
	}

	this.changeProtocol = function () {
		this.isOSS = this.origin.protocol.startsWith("oss:")

		this.checkPort()
	}

	this.changeAddr = function () {
		if (this.serverType == "httpProxy") {
			if (this.origin.addr.startsWith("http://")) {
				this.origin.protocol = "http"
			} else if (this.origin.addr.startsWith("https://")) {
				this.origin.protocol = "https"
			}
		}

		this.checkPort()
	}

	this.checkPort = function () {
		this.addrError = ""

		// HTTP
		if (this.origin.protocol == "http") {
			if (this.origin.addr.endsWith(":443")) {
				this.addrError = t('addPopup@443通常是HTTPS协议端口，请确认源站协议选择是否正确。')
			} else if (this.origin.addr.endsWith(":8443")) {
				this.addrError = t('addPopup@8443通常是HTTPS协议端口，请确认源站协议选择是否正确。')
			}
		}

		// HTTPS
		if (this.origin.protocol == "https") {
			if (this.origin.addr.endsWith(":80")) {
				this.addrError = t('addPopup@80通常是HTTP协议端口，请确认源站协议选择是否正确。')
			} else if (this.origin.addr.endsWith(":8080")) {
				this.addrError = t('addPopup@8080通常是HTTP协议端口，请确认源站协议选择是否正确。')
			}
		}
	}

	// 验证所有表单字段
	this.validateAllFields = function() {
		var errors = []

		// 验证地址
		var addrError = this.validateAddr(this.origin.addr)
		if (addrError) {
			errors.push(addrError)
		}

		// 验证权重
		var weightError = this.validateWeight(this.origin.weight)
		if (weightError) {
			errors.push(weightError)
		}

		// 验证连接超时时间
		if (this.origin.connTimeout !== undefined) {
			var connTimeoutError = this.validateTimeout(this.origin.connTimeout, t('连接超时时间'))
			if (connTimeoutError) {
				errors.push(connTimeoutError)
			}
		}

		// 验证读取超时时间
		if (this.origin.readTimeout !== undefined) {
			var readTimeoutError = this.validateTimeout(this.origin.readTimeout, t('读取超时时间'))
			if (readTimeoutError) {
				errors.push(readTimeoutError)
			}
		}

		// 验证最大连接数
		if (this.origin.maxConns !== undefined) {
			var maxConnsError = this.validateConnCount(this.origin.maxConns, t('最大连接数'))
			if (maxConnsError) {
				errors.push(maxConnsError)
			}
		}

		// 验证最大空闲连接数
		if (this.origin.maxIdleConns !== undefined) {
			var maxIdleConnsError = this.validateConnCount(this.origin.maxIdleConns, t('最大空闲连接数'))
			if (maxIdleConnsError) {
				errors.push(maxIdleConnsError)
			}
		}

		// 验证空闲超时时间
		if (this.origin.idleTimeout !== undefined) {
			var idleTimeoutError = this.validateTimeout(this.origin.idleTimeout, t('空闲超时时间'))
			if (idleTimeoutError) {
				errors.push(idleTimeoutError)
			}
		}

		return errors
	}

	this.submitForm = function (e) {
		// 首先阻止默认提交行为
		if (e && e.preventDefault) {
			e.preventDefault()
		}
		if (e && e.stopPropagation) {
			e.stopPropagation()
		}

		console.log("this.submitForm -> e", e)

		// 验证所有字段
		var errors = this.validateAllFields()
		if (errors.length > 0) {
			// 弹窗显示第一个错误信息
			teaweb.warn(errors[0])
			return false
		}

		// 验证通过，提交表单
		Tea.runActionOn(document.getElementById("updateOriginForm"))

		return false
	}
})