Tea.context(function () {
	this.addr = ""
	this.protocol = ""
	const t = this.t.bind(this)
	this.isOSS = false

	this.addrError = ""

	if (this.isHTTP) {
		this.protocol = "http"
	} else if (this.serverType == "tcpProxy") {
		this.protocol = "tcp"
	} else if (this.serverType == "udpProxy") {
		this.protocol = "udp"
	}

	// 验证地址格式（使用正则）
	this.validateAddr = function(addr) {
		if (!addr || addr.trim() === "") {
			return t('源站地址不能为空')
		}

		addr = addr.trim()
		
		// 移除协议前缀
		var cleanAddr = addr.replace(/^https?:\/\//, '')
		
		// IP地址正则：包含端口的完整格式
		var ipWithPortRegex = /^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(:[1-9][0-9]{0,4})?$/
		
		// 域名正则：包含端口的完整格式
		var domainWithPortRegex = /^[a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?(\.[a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?)*(\.[a-zA-Z]{2,})(:[1-9][0-9]{0,4})?$/
		
		// 简单IP地址正则：不含端口
		var simpleIpRegex = /^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/
		
		// 简单域名正则：不含端口
		var simpleDomainRegex = /^[a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?(\.[a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?)*(\.[a-zA-Z]{2,})$/

		if (!ipWithPortRegex.test(cleanAddr) && !domainWithPortRegex.test(cleanAddr) && 
			!simpleIpRegex.test(cleanAddr) && !simpleDomainRegex.test(cleanAddr)) {
			return t('源站地址格式不正确，请输入有效的IP地址或域名')
		}

		return ""
	}

	// 验证权重（使用正则）
	this.validateWeight = function(weight) {
		if (!weight || weight.trim() === "") {
			return t('权重不能为空')
		}

		// 正整数正则：1-1000
		var weightRegex = /^([1-9]|[1-9][0-9]|[1-9][0-9][0-9]|1000)$/
		
		if (!weightRegex.test(weight.trim())) {
			return t('权重必须是1-1000之间的整数')
		}

		return ""
	}

	// 验证超时时间（使用正则）
	this.validateTimeout = function(timeout, fieldName) {
		if (!timeout || timeout.trim() === "") {
			return ""  // 允许为空
		}

		// 非负整数正则：0-3600
		var timeoutRegex = /^(0|[1-9][0-9]{0,3})$/
		var timeoutNum = parseInt(timeout.trim())
		
		if (!timeoutRegex.test(timeout.trim()) || timeoutNum > 3600) {
			return fieldName + t('必须是0-3600之间的整数')
		}

		return ""
	}

	// 验证连接数（使用正则）
	this.validateConnCount = function(count, fieldName) {
		if (!count || count.trim() === "") {
			return ""  // 允许为空
		}

		// 非负整数正则：0-100000
		var countRegex = /^(0|[1-9][0-9]{0,5})$/
		var countNum = parseInt(count.trim())
		
		if (!countRegex.test(count.trim()) || countNum > 100000) {
			return fieldName + t('必须是0-100000之间的整数')
		}

		return ""
	}

	this.changeProtocol = function () {
		this.isOSS = this.protocol.startsWith("oss:")

		if (this.protocol == "http") {
			this.detectHTTPS()
		} else {
			this.adviceHTTPS = false
		}

		this.checkPort()
	}

	this.changeAddr = function () {
		this.adviceHTTPS = false

		if (this.serverType == "httpProxy") {
			if (this.addr.startsWith("http://")) {
				this.protocol = "http"
			} else if (this.addr.startsWith("https://")) {
				this.protocol = "https"
			}
		}

		this.checkPort()
	}

	this.checkPort = function () {
		this.addrError = ""

		// HTTP
		if (this.protocol == "http") {
			if (this.addr.endsWith(":443")) {
				this.addrError = t('addPopup@443通常是HTTPS协议端口，请确认源站协议选择是否正确。')
			} else if (this.addr.endsWith(":8443")) {
				this.addrError = t('addPopup@8443通常是HTTPS协议端口，请确认源站协议选择是否正确。')
			}
		}

		// HTTPS
		if (this.protocol == "https") {
			if (this.addr.endsWith(":80")) {
				this.addrError = t('addPopup@80通常是HTTP协议端口，请确认源站协议选择是否正确。')
			} else if (this.addr.endsWith(":8080")) {
				this.addrError = t('addPopup@8080通常是HTTP协议端口，请确认源站协议选择是否正确。')
			}
		}

		// 如果没有协议端口错误，执行地址格式验证
		if (this.addrError === "") {
			this.addrError = this.validateAddr(this.addr)
		}
	}

	this.adviceHTTPS = false
	var isDetectingHTTPS = false
	this.detectHTTPS = function () {
		if (isDetectingHTTPS) {
			return
		}
		isDetectingHTTPS = true

		this.adviceHTTPS = false
		if (this.protocol == "http") {
			this.$post(".detectHTTPS")
				.params({
					addr: this.addr
				})
				.success(function (resp) {
					this.adviceHTTPS = resp.data.isOk
					if (resp.data.isOk) {
						this.addr = resp.data.addr
					}
				})
				.done(function () {
					isDetectingHTTPS = false
				})
		} else {
			isDetectingHTTPS = false
		}
	}

	this.switchToHTTPS = function () {
		this.adviceHTTPS = false
		this.protocol = "https"

		if (this.addr.endsWith(":80")) {
			this.addr = this.addr.substring(0, this.addr.length - (":80").length)
		}
	}

	// 验证所有表单字段
	this.validateAllFields = function() {
		var errors = []

		// 验证地址
		var addrError = this.validateAddr(this.addr)
		if (addrError) {
			errors.push(addrError)
		}

		// 验证权重
		var weightInput = document.querySelector('input[name="weight"]')
		if (weightInput) {
			var weightError = this.validateWeight(weightInput.value)
			if (weightError) {
				errors.push(weightError)
			}
		}

		// 验证连接超时时间
		var connTimeoutInput = document.querySelector('input[name="connTimeout"]')
		if (connTimeoutInput) {
			var connTimeoutError = this.validateTimeout(connTimeoutInput.value, t('连接超时时间'))
			if (connTimeoutError) {
				errors.push(connTimeoutError)
			}
		}

		// 验证读取超时时间
		var readTimeoutInput = document.querySelector('input[name="readTimeout"]')
		if (readTimeoutInput) {
			var readTimeoutError = this.validateTimeout(readTimeoutInput.value, t('读取超时时间'))
			if (readTimeoutError) {
				errors.push(readTimeoutError)
			}
		}

		// 验证最大连接数
		var maxConnsInput = document.querySelector('input[name="maxConns"]')
		if (maxConnsInput) {
			var maxConnsError = this.validateConnCount(maxConnsInput.value, t('最大连接数'))
			if (maxConnsError) {
				errors.push(maxConnsError)
			}
		}

		// 验证最大空闲连接数
		var maxIdleConnsInput = document.querySelector('input[name="maxIdleConns"]')
		if (maxIdleConnsInput) {
			var maxIdleConnsError = this.validateConnCount(maxIdleConnsInput.value, t('最大空闲连接数'))
			if (maxIdleConnsError) {
				errors.push(maxIdleConnsError)
			}
		}

		// 验证空闲超时时间
		var idleTimeoutInput = document.querySelector('input[name="idleTimeout"]')
		if (idleTimeoutInput) {
			var idleTimeoutError = this.validateTimeout(idleTimeoutInput.value, t('空闲超时时间'))
			if (idleTimeoutError) {
				errors.push(idleTimeoutError)
			}
		}

		return errors
	}

	this.submitForm = function (e) {
		// 首先阻止默认提交行为
		if (e && e.preventDefault) {
			e.preventDefault()
		}
		if (e && e.stopPropagation) {
			e.stopPropagation()
		}

		console.log("this.submitForm -> e", e)

		// 验证所有字段
		var errors = this.validateAllFields()
		if (errors.length > 0) {
			// 弹窗显示所有错误信息
			teaweb.warn(errors[0])
			return false
		}

		// 验证通过，提交表单
		Tea.runActionOn(document.getElementById("addOriginForm"))

		return false
	}
})