Tea.context(function () {
	var t = this.t.bind(this)
	this.success = NotifyReloadSuccess(t('index_保存成功_0101'))

	this.currentMainTab = null;

	// 处理url 删除? 后面的部分
	function handleUrl(url) {
		return url.split('?')[0]
	}

	// 新的分组映射
	const groupMap = {
		basic: {
			name: t('index_基础配置_0101'),
			items: [
				"serverBasicSettings",
				"serverNamesSettings",
				"serverDnsSettings",
				"serverHttpSettings",
				"serverHttpsSettings",
				"serverReverseProxySettings",
				"serverUdpSettings",
				"serverTlsSettings",
				"serverTcpSettings"
			]
		},
		security: {
			name: t('index_安全防护_0101'),
			items: [
				"serverUamSettings",
				"serverCcSettings",
				"serverDefenseSettings",
				"serverReferersSettings",
				"serverUserAgentSettings",
				"serverAccessSettings"
			]
		},
		waf:{
			name: 'WAF',
			items: [
				"serverWafSettings"
			]
		},
		traffic: {
			name: t('index_流量与访问_0101'),
			items: [
				"serverRequestLimitSettings",
				"serverRemoteAddrSettings",
				"serverAccessLogSettings",
				"serverStatSettings",
				"serverTrafficSettings"
			]
		},
		performance: {
			name: t('index_性能优化_0101'),
			items: [
				"serverCacheSettings",
				"serverCompressionSettings",
				"serverOptimizationSettings",
				"serverWebpSettings",
				"serverCharsetSettings",
				"serverFastcgiSettings",
				"serverWebSettings"
			]
		},
		page_route: {
			name: t('index_页面与路由_0101'),
			items: [
				"serverRedirectsSettings",
				"serverLocationSettings",
				"serverRewriteSettings",
				"serverPagesSettings",
				"serverHeadersSettings",
				"serverWebsocketSettings"
			]
		},
		enhancement: {
			name: t('index_其他设置_0101'),
			items: [
				"serverMultimediaSettings",
				"serverRequestScriptsSettings",
				"serverCommonSettings"
			]
		}
	};

	this.allCode = this.leftMenuItems.map(function (item) {
		return item.code;
	});

	// 根据有权限的code把 groupMap 进行过滤 如果是空的则删除
	Object.keys(groupMap).forEach(key => {
		groupMap[key].items = groupMap[key].items.filter(item => this.allCode.includes(item));
		if (groupMap[key].items.length === 0) {
			delete groupMap[key];
		}
	});

	// 生成分组后的菜单结构
	this.menuGroups = {};
	Object.keys(groupMap).forEach(groupKey => {
		this.menuGroups[groupKey] = [];
	});
	this.leftMenuItems.forEach(menu => {
		if (!menu.name || menu.name === "-") return;
		Object.keys(groupMap).forEach(groupKey => {
			if (groupMap[groupKey].items.includes(menu.code)) {
				this.menuGroups[groupKey].push(menu);
			}
		});
	});

	// 主分类tab自动生成
	this.mainTabs = Object.keys(groupMap).map(function (key, idx) {
		return { code: key, name: groupMap[key].name, active: idx === 0 };
	});

	// 小分类菜单自动生成（初始为第一个大类）
	this.sideMenus = (this.menuGroups[this.mainTabs[0].code] || []).map(function (item, idx) {
		return { code: item.code, name: item.name, active: idx === 0, url: item.url, isOff: item.isOff };
	});
	this.currentMainTab = this.mainTabs[0].code;
	this.currentSideMenu = this.sideMenus.length > 0 ? this.sideMenus[0].code : '';

	// 切换主分类tab
	this.selectMainTab = function (code) {
		this.mainTabs.forEach(function (tab) {
			tab.active = (tab.code === code)
		});
		// 切换小分类，默认激活第一个
		this.sideMenus = (this.menuGroups[code] || []).map(function (item, idx) {
			return { code: item.code, name: item.name, active: idx === 0, url: item.url, isOff: item.isOff };
		});
		if (this.sideMenus && this.sideMenus.length > 0) {
			this.currentMainTab = code;
			this.currentSideMenu = this.sideMenus[0].code
		}
	}
	// 当前主分类code
	this.selectMainTab(this.mainTabs[0].code)
	// 切换左侧小分类
	this.selectSideMenu = function (code) {
		this.sideMenus.forEach(function (item) {
			item.active = (item.code === code)
		})
		this.currentSideMenu = code
	}

	/**
	 * 用户相关
	 */
	this.userSelectorVisible = false

	this.showUserSelector = function () {
		this.userSelectorVisible = !this.userSelectorVisible
	}

	this.userId = 0
	this.plans = []
	this.userPlanId = 0
	this.oldClusterId = this.server.clusterId

	if (this.userPlan != null) {
		this.userPlanId = this.userPlan.id
	}

	this.changeUserId = function (v) {
		this.userId = v

		if (this.userId == 0) {
			this.plans = []
			return
		}

		this.$post("/servers/users/plans")
			.params({
				userId: this.userId,
				serverId: this.serverId
			})
			.success(function (resp) {
				this.plans = resp.data.plans
			})
	}

	if (this.user != null) {
		this.changeUserId(this.user.id)
	}
})