Tea.context(function () {
	const t = this.t.bind(this)
	this.formatSeconds = function (seconds) {
		if (seconds < 60) {
			return seconds + t('index_秒_0101')
		}
		if (seconds < 3600) {
			return Math.ceil(seconds / 60) + t('index_分钟_0101')
		}
		if (seconds < 86400) {
			return Math.ceil(seconds / 3600) + t('index_小时_0101')
		}
		return Math.ceil(seconds / 86400) + t('server_http-cache-refs-config-box@天')
	}

	this.checkedItemIds = []
	this.hasSelectedItems = false

	this.updateItem = function (itemId) {
		teaweb.popup(Tea.url(".updateIPPopup", {itemId: itemId}), {
			height: "30em",
			title: t('iplists@修改IP'),
			callback: function () {
				teaweb.success(t('cache_index@保存成功'), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.deleteItem = function (itemId) {
		let that = this
		teaweb.confirm(t('iplists@确定要删除这个IP吗'), function () {
			that.$post(".deleteIP")
				.params({
					"itemId": itemId
				})
				.refresh()
		})
	}

	this.readAllItems = function () {
		this.$post(".readAll")
			.success(function () {
				teaweb.reload()
			})
	}

	this.viewLogs = function (itemId) {
		teaweb.popup("/servers/iplists/accessLogsPopup?itemId=" + itemId, {
			title: t('iplists@访问日志'),
			width: "50em",
			height: "30em"
		})
	}

	this.deleteSelectedItems = function () {
		if (this.checkedItemIds.length === 0) {
			return
		}

		let that = this
		teaweb.confirm(t('iplists@确定要删除选中的{0}个IP吗', [this.checkedItemIds.length]), function () {
			Tea.action("/servers/iplists/deleteItems")
				.post()
				.params({
					itemIds: that.checkedItemIds
				})
				.success(function () {
					teaweb.successToast(t('iplists@批量删除成功'), 1200, teaweb.reload)
				})
		})
	}

	this.cancelSelectedItems = function () {
		this.checkedItemIds = []
		this.hasSelectedItems = false
		teaweb.reload()
	}
})