Tea.context(function () {
	this.windowWidth = window.innerWidth
	this.miniWidth = 760
	this.columnWidth1 = 800
	this.columnWidth2 = 900
	this.columnWidth3 = 1000
	this.columnWidth4 = 1100
	this.columnWidth5 = 1200
  const t = this.t

	// 解析URL参数获取排序状态
	this.getSortOrder = function(paramName) {
		const urlParams = new URLSearchParams(window.location.search)
		return urlParams.get(paramName) || ''
	}

	// 获取当前排序状态
	this.trafficOutOrder = this.getSortOrder('trafficOutOrder')
	this.requestsOrder = this.getSortOrder('requestsOrder') 
	this.attackRequestsOrder = this.getSortOrder('attackRequestsOrder')

	// 获取排序状态用于表格列配置
	const trafficOutOrder = this.trafficOutOrder
	const requestsOrder = this.requestsOrder
	const attackRequestsOrder = this.attackRequestsOrder
  console.log("attackRequestsOrder", attackRequestsOrder)

	// 初始化表格列配置
	this.tableColumns = [
		{
			title: t('index_网站名称_0101'),
			dataIndex: 'name',
			key: 'name',
			minWidth: 200,
			scopedSlots: { customRender: 'name' },
		},
		{
			title: t('index_所属用户_0101'),
			dataIndex: 'user',
			key: 'user',
			minWidth: 250,
			scopedSlots: { customRender: 'user' }
		},
		{
			title: t('index_部署集群_0101'),
			dataIndex: 'cluster.name',
			key: 'cluster',
			width: 150
		},
		{
			title: t('index_域名_0101'),
			dataIndex: 'serverName',
			key: 'serverName',
			scopedSlots: { customRender: 'serverName' }
		},
		{
			title: t('index_端口_0101'),
			dataIndex: 'ports',
			key: 'ports',
			width: 200,
			scopedSlots: { customRender: 'ports' }
		},
		{
			title: t('index_下行带宽_0101'),
			dataIndex: 'bandwidth',
			key: 'bandwidth',
			width: 150,
			className: 'value-column center',
			scopedSlots: { customRender: 'bandwidth' },
			sorter: (a, b) => (a.bandwidthBits || 0) - (b.bandwidthBits || 0),
			defaultSortOrder: trafficOutOrder ? (trafficOutOrder === 'asc' ? 'ascend' : 'descend') : null
		},
		{
			title: 'QPS',
			dataIndex: 'qps',
			key: 'qps',
			width: 100,
			className: 'value-column center',
			scopedSlots: { customRender: 'qps' },
			sorter: (a, b) => {
				// qps是格式化后的字符串，需要转换为数值进行比较
				const aVal = parseFloat(a.qps) || 0
				const bVal = parseFloat(b.qps) || 0
				return aVal - bVal
			},
			defaultSortOrder: requestsOrder ? (requestsOrder === 'asc' ? 'ascend' : 'descend') : null
		},
		{
			title: t('index_攻击QPS_0101'),
			dataIndex: 'attackQps',
			key: 'attackQps',
			width: 100,
			className: 'value-column center',
			scopedSlots: { customRender: 'attackQps' },
			sorter: (a, b) => {
				// attackQPS是格式化后的字符串，需要转换为数值进行比较
				const aVal = parseFloat(a.attackQPS) || 0
				const bVal = parseFloat(b.attackQPS) || 0
				return aVal - bVal
			},
			defaultSortOrder: attackRequestsOrder ? (attackRequestsOrder === 'asc' ? 'ascend' : 'descend') : null
		},
		{
			title: t('index_状态_0101'),
			dataIndex: 'status',
			key: 'status',
			width: 120,
			className: 'center',
			scopedSlots: { customRender: 'status' }
		},
		{
			title: t('index_操作_0101'),
			dataIndex: 'actions',
			key: 'actions',
			width: 180,
			className: 'op',
			scopedSlots: { customRender: 'actions' }
		}
	]

  console.log("this.tableColumns", this.tableColumns)

	this.servers.forEach(function (v) {
		v["status"] = {
			isOk: false,
			message: "",
			todo: ""
		}
	})

	this.$delay(function () {
		if (this.checkDNS) {
			this.loadStatus()
		}

		let that = this
		this.$watch("checkDNS", function (v) {
			if (v) {
				that.loadStatus()
			}
		})
	})

	this.loadStatus = function () {
		let serverIds = this.servers.map(function (v) {
			return v.id
		})
		this.$post(".status")
			.params({
				serverIds: serverIds
			})
			.timeout(300)
			.success(function (resp) {
				let status = resp.data.status
				this.servers.forEach(function (server) {
					if (typeof status[server.id] === "object") {
						server.status = status[server.id]
					}
				})
			})
	}

	/**
	 * 最近使用
	 */
	this.latestVisible = false

	this.showLatest = function () {
		this.latestVisible = !this.latestVisible
	}

	/**
	 * 全选
	 */
	this.checkedServerIds = []
	
	// 重构选择逻辑，使用新的表格selection实现
	this.changeAllChecked = function (checked) {
		if (checked) {
			// 全选
			this.checkedServerIds = this.servers.map(function (server) {
				return server.id
			})
		} else {
			// 取消全选
			this.checkedServerIds = []
		}
		// 强制更新数据，确保UI更新
		this.$forceUpdate()
	}

	this.changeServerChecked = function () {
		// 在使用b-table组件后，此函数主要用于响应单个复选框变化
		// 变化后需要更新checkedServerIds
		this.updateCheckedServers()
	}

	this.updateCheckedServers = function () {
		// b-table的rowSelection会自动处理选中状态
		// 这里主要用于触发UI更新
		this.$forceUpdate()
	}

	/**
	 * 处理表格排序
	 */
	this.handleTableChange = (sorter) => {
		console.log("handleTableChange -> sorter", sorter)
		
		// 构建新的URL参数
		const urlParams = new URLSearchParams(window.location.search)
		
		// 清除所有排序参数
		urlParams.delete('trafficOutOrder')
		urlParams.delete('requestsOrder') 
		urlParams.delete('attackRequestsOrder')
		urlParams.delete('page') // 排序时重置页码
		
		// 根据排序字段添加对应的排序参数
		if (sorter && sorter.field) {
			// 获取当前排序状态
			let currentOrder = ''
			if (sorter.field === 'bandwidth') {
				currentOrder = this.trafficOutOrder
			} else if (sorter.field === 'qps') {
				currentOrder = this.requestsOrder
			} else if (sorter.field === 'attackQps') {
				currentOrder = this.attackRequestsOrder
			}
			
			// 确定新的排序方向：无排序 -> 降序 -> 升序 -> 无排序
			let newOrder = ''
			if (!currentOrder || currentOrder === '') {
				newOrder = 'desc' // 无排序时，第一次点击设为降序
			} else if (currentOrder === 'desc') {
				newOrder = 'asc'  // 降序时，点击设为升序
			} else if (currentOrder === 'asc') {
				newOrder = ''     // 升序时，点击取消排序
			}
			
			// 设置新的排序参数
			if (newOrder) {
				if (sorter.field === 'bandwidth') {
					urlParams.set('trafficOutOrder', newOrder)
				} else if (sorter.field === 'qps') {
					urlParams.set('requestsOrder', newOrder)
				} else if (sorter.field === 'attackQps') {
					urlParams.set('attackRequestsOrder', newOrder)
				}
			}
		}
		
		// 构建新的URL并跳转
		const newUrl = window.location.pathname + '?' + urlParams.toString()
		window.location.href = newUrl
	}

	this.resetCheckedServers = function () {
		// 清空选择
		this.checkedServerIds = []
		// 强制更新数据，确保UI更新
		this.$forceUpdate()
	}

	this.deleteServers = function () {
		let that = this
		teaweb.confirm(t('index_确定要删除所选的count个网站吗_0101', [this.checkedServerIds.length]), function () {
			that.$post(".deleteServers")
				.params({
					serverIds: that.checkedServerIds // 修改this为that
				})
				.success(function () {
					teaweb.reload()
				})
		})
	}

	/**
	 * 切换网站启用/停用状态
	 */
	this.toggleServerStatus = function (server) {
		// 防止重复点击
		if (server.isUpdating) {
			return
		}

		// 准备新的状态值
		const newStatus = !server.isOn
		const actionText = newStatus ? t('启用') : t('停用')
		
		// 显示确认对话框
		teaweb.confirm(t('确定要actionText网站name吗', [actionText, server.name]), () => {
			// 用户确认后，设置更新状态
			this.$set(server, 'isUpdating', true)
			
			// 先获取服务器详细信息
			this.$get("/servers/server/settings")
				.params({
					serverId: server.id
				})
				.success((resp) => {
					// 获取服务器数据
					const serverData = resp.data.server
					
					// 更新状态字段
					serverData.isOn = newStatus ? 1 : 0
					
					// 提交更新
					this.$post("/servers/server/settings")
						.params({
							serverId: server.id,
							name: serverData.name,
							userPlanId: serverData.userPlanId || 0,
							clusterId: serverData.clusterId,
							keepOldConfigs: serverData.keepOldConfigs || false,
							isOn: serverData.isOn,
							description: serverData.description || '',
							groupIds: serverData.groups ? serverData.groups.map(group => group.id) : []
						})
						.success(() => {
							// 更新本地状态
							server.isOn = newStatus
							this.$message.success(t('网站状态已更新'))
							
							// 如果启用了DNS检查，重新加载状态
							if (this.checkDNS) {
								this.loadStatus()
							}
						})
						.fail((resp) => {
							// 恢复原状态
							server.isOn = !newStatus
							this.$message.error(resp.message || t('更新失败'))
						})
						.done(() => {
							// 清除更新状态
							this.$set(server, 'isUpdating', false)
						})
				})
				.fail((resp) => {
					// 获取数据失败
					this.$message.error(resp.message || t('获取服务器信息失败'))
					this.$set(server, 'isUpdating', false)
				})
		}, () => {
			// 用户取消，不需要做任何操作
			// 因为还没有开始更新，所以不需要清除更新状态
		})
	}
})