Tea.context(function () {
	this.sorting = false; // 是否正在排序
	const t = this.t.bind(this);
	this.columns = [
		{
			title: '',
			key: 'handle',
			dataIndex: 'handle',
			width: '50px',
			scopedSlots: { customRender: 'handleSlot' }
		},
		{
			title: t("servers_groups_index@分组名称"),
			dataIndex: 'name',
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' }
		},
		{
			title: t("servers_groups_index@服务数量"),
			dataIndex: 'countServers',
			key: 'countServers',
			align: 'center',
			width: '120px',
			scopedSlots: { customRender: 'countSlot' }
		},
		{
			title: t("servers_groups_index@操作"),
			key: 'action',
			width: '150px',
			scopedSlots: { customRender: 'actionSlot' }
		}
	];

	this.handleSort = function (groupIds) {
		// 防止重复请求
		if (this.sorting) {
			return;
		}

		setTimeout(() => {
			this.sorting = true;

			this.$post("/servers/groups/sort")
				.params({
					groupIds: groupIds
				})
				.success(function () {
					teaweb.successToast(t("servers_groups_index@排序保存成功"));
				})
				.fail(() => {
					teaweb.failToast(t("servers_groups_index@排序保存失败，请重试"));
				})
				.finally(() => {
					this.sorting = false;
				});
		}, 100);
	};

	this.createGroup = function () {
		teaweb.popup("/servers/groups/createPopup", {
			title: t("servers_groups_index@创建分组"),
			callback: function () {
				teaweb.success(t("servers_groups_index@保存成功"), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.deleteGroup = function (groupId) {
		let that = this
		teaweb.confirm(t("servers_groups_index@确定要删除这个分组吗"), function () {
			that.$post("/servers/groups/group/delete")
				.params({
					groupId: groupId
				})
				.success(function () {
					teaweb.success(t("servers_groups_index@删除成功"), function () {
						teaweb.reload()
					})
				})
		})
	}
})