Tea.context(function () {
	const t = this.t.bind(this)
	// 表格列定义
	this.columns = [
		{
			title: t('waf_index@策略名称'),
			dataIndex: "name",
			key: "name",
			scopedSlots: { customRender: 'name' }
		},
		{
			title: t('waf_index@入站规则分组'),
			dataIndex: "countInbound",
			key: "inbound",
			align: "center",
			scopedSlots: { customRender: 'inbound' }
		},
		{
			title: t('waf_index@出站规则分组'),
			dataIndex: "countOutbound",
			key: "outbound",
			align: "center",
			scopedSlots: { customRender: 'outbound' }
		},
		{
			title: t('waf_index@集群数'),
			dataIndex: "countClusters",
			key: "clusterCount",
			align: "center",
			scopedSlots: { customRender: 'clusterCount' }
		},
		{
			title: t('waf_index@状态'),
			dataIndex: "isOn",
			key: "status",
			align: "center",
			width: "120px",
			scopedSlots: { customRender: 'status' }
		},
		{
			title: t('waf_index@操作'),
			dataIndex: "actions",
			key: "actions",
			width: "160px",
			scopedSlots: { customRender: 'actions' }
		}
	]

	// 创建策略
	this.createPolicy = function () {
		teaweb.popup("/servers/components/waf/createPopup", {
			title: t('waf_index@创建WAF策略'),
			height: "27em",
			callback: function () {
				teaweb.success(t('waf_index@保存成功'), function () {
					window.location.reload()
				})
			}
		})
	}

	// 删除策略
	this.deletePolicy = function (policyId) {
		let that = this
		teaweb.confirm(t('waf_index@确定要删除此WAF策略吗'), function () {
			that.$post("/servers/components/waf/delete")
				.params({
					firewallPolicyId: policyId
				})
				.refresh()
		})
	}
})