Tea.context(function () {
const t = this.t.bind(this)
this.groupsColumns = [
		{
			title: '',
			dataIndex: 'handle',
			key: 'handle',
			scopedSlots: { customRender: 'handleSlot' },
			width: '60px',
			align: 'center',
		},
		{
			title: t('waf_groups@规则分组'),
			dataIndex: 'name',
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' }
		},
		{
			title: t('waf_groups@规则集'),
			dataIndex: 'countSets',
			key: 'countSets',
			scopedSlots: { customRender: 'countSetsSlot' },
			width: '10%',
			align: 'center'
		},
		{
			title: t('waf_groups@操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '20%',
			align: 'center'
		}
	];
	
	// 排序
	this.sortGroups = function (items) {
		
		this.$post(".sortGroups")
			.params({
				firewallPolicyId: this.firewallPolicyId,
				type: this.type,
				groupIds: items
			})
			.success(function () {
				teaweb.success(t('waf_groups@排序保存成功'), 1000);
			})
			.fail(function(resp) {
				teaweb.warn(t('waf_groups@排序保存失败') + resp.message);
			})
	};

	// 启用
	this.enableGroup = function (groupId) {
		this.$post(".updateGroupOn")
			.params({
				groupId: groupId,
				isOn: 1
			})
			.success(function() {
				teaweb.successToast(t('waf_groups@规则分组已启用'));
				setTimeout(function() {
					window.location.reload();
				}, 1000);
			})
			.fail(function(resp) {
				teaweb.warn(t('waf_groups@启用失败') + resp.message);
			});
	}

	// 停用
	this.disableGroup = function (groupId) {
		
		this.$post(".updateGroupOn")
			.params({
				groupId: groupId,
				isOn: 0
			})
			.success(function() {
				teaweb.successToast(t('waf_groups@规则分组已停用'));
				setTimeout(function() {
					window.location.reload();
				}, 1000);
			})
			.fail(function(resp) {
				teaweb.warn(t('waf_groups@停用失败') + resp.message);
			});
	}

	// 删除
	this.deleteGroup = function (groupId) {
		teaweb.confirm(t('waf_groups@确定要删除此规则分组吗'), function () {
			
			this.$post(".deleteGroup")
				.params({
					firewallPolicyId: this.firewallPolicyId,
					groupId: groupId
				})
				.success(function() {
					teaweb.successToast(t('waf_groups@规则分组已删除'));
					setTimeout(function() {
						window.location.reload();
					}, 1000);
				})
				.fail(function(resp) {
					teaweb.warn(t('waf_groups@删除失败') + resp.message);
				});
		})
	}

	// 添加分组
	this.createGroup = function (type) {
		teaweb.popup("/servers/components/waf/createGroupPopup?firewallPolicyId=" + this.firewallPolicyId + "&type=" + type, {
			title: t('waf_groups@添加规则分组'),
			width: '40em',
			height: '30em',
			callback: function () {
				teaweb.success(t('waf_groups@规则分组创建成功'), function () {
					window.location.reload()
				})
			}
		})
	}
})