Tea.context(function () {
	const t = this.t.bind(this)
	this.$delay(function () {
		let that = this
		sortTable(function () {
			let setIds = []
			document
				.querySelectorAll("tbody[data-set-id]")
				.forEach(function (v) {
					setIds.push(v.getAttribute("data-set-id"))
				})
			that.$post(".sortSets")
				.params({
					groupId: that.group.id,
					setIds: setIds
				})
				.success(function () {
					teaweb.successToast(t('waf_group@排序保存成功'))
				})
		})
	})

	// 更改分组
	this.updateGroup = function (groupId) {
		teaweb.popup("/servers/components/waf/updateGroupPopup?groupId=" + groupId, {
			title: t('waf_group@修改分组'),
			height: "20em",
			callback: function () {
				teaweb.success(t('waf_group@保存成功'), function () {
					window.location.reload()
				})
			}
		})
	}

	// 创建规则集
	this.createSet = function (groupId) {
		teaweb.popup("/servers/components/waf/createSetPopup?firewallPolicyId=" + this.firewallPolicyId + "&groupId=" + groupId + "&type=" + this.type, {
			title: t('waf_group@添加规则集'),
			width: "50em",
			height: "40em",
			callback: function () {
				teaweb.success(t('waf_group@保存成功'), function () {
					window.location.reload()
				})
			}
		})
	}

	// 修改规则集
	this.updateSet = function (setId) {
		teaweb.popup("/servers/components/waf/updateSetPopup?firewallPolicyId=" + this.firewallPolicyId + "&groupId=" + this.group.id + "&type=" + this.type + "&setId=" + setId, {
			title: t('waf_group@修改规则集'),
			width: "50em",
			height: "40em",
			callback: function () {
				teaweb.success(t('waf_group@保存成功'), function () {
					window.location.reload()
				})
			}
		})
	}

	// 停用|启用规则集
	this.updateSetOn = function (setId, isOn) {
		this.$post(".updateSetOn")
			.params({
				setId: setId,
				isOn: isOn ? 1 : 0
			})
			.refresh()
	}

	// 删除规则集
	this.deleteSet = function (setId) {
		let that = this
		teaweb.confirm(t('waf_group@确定要删除此规则集吗'), function () {
			that.$post(".deleteSet")
				.params({
					groupId: this.group.id,
					setId: setId
				})
				.refresh()
		})
	}
})