Tea.context(function () {
	const t = this.t.bind(this);
	// 定义表格列
	this.policyColumns = [
		{
			title: t("cache_index_js@策略名称"),
			key: "name",
			dataIndex: "name",
			scopedSlots: { customRender: 'name' },
			width: "20%"
		},
		{
			title: t("cache_index_js@策略类型"),
			key: "type",
			dataIndex: "type",
			scopedSlots: { customRender: 'type' },
			width: "15%"
		},
		{
			title: t("cache_index_js@容量"),
			key: "capacity",
			dataIndex: "capacity",
			scopedSlots: { customRender: 'capacity' },
			width: "25%"
		},
		{
			title: t("cache_index_js@集群数"),
			key: "clusterCount",
			dataIndex: "clusterCount",
			scopedSlots: { customRender: 'clusterCount' },
			width: "10%",
			align: "center"
		},
		{
			title: t("certs_index@状态"),
			key: "status",
			dataIndex: "status",
			scopedSlots: { customRender: 'status' },
			width: "10%",
			align: "center"
		},
		{
			title: t("certs_index@操作"),
			key: "actions",
			scopedSlots: { customRender: 'actions' },
			width: "20%",
			className: "two op"
		}
	]
	
	// 预处理表格数据的方法
	this.processPolicyTableData = function(cachePolicies, infos) {
    console.log("this.processPolicyTableData -> cachePolicies", cachePolicies)
    console.log("this.processPolicyTableData -> infos", infos)
		if (!cachePolicies || !infos) {
			return []
		}
		
		return cachePolicies.map((policy, index) => {
			return {
				...policy,
				typeName: infos[index] ? infos[index].typeName : "",
				clusterCount: infos[index] ? infos[index].countClusters : 0
			}
		})
	}

	// 创建策略
	this.createPolicy = function () {
		teaweb.popup("/servers/components/cache/createPopup", {
			title: t('cache_index_js@创建缓存策略'),
			height: "27em",
			callback: function () {
				teaweb.success(t("acme_users_index_js@保存成功"), function () {
					window.location.reload()
				})
			}
		})
	}

	// 删除策略
	this.deletePolicy = function (policyId) {
		let that = this
		teaweb.confirm(t("cache_index_js@确定要删除此缓存策略吗"), function () {
			that.$post("/servers/components/cache/delete")
				.params({
					cachePolicyId: policyId
				})
				.refresh()
		})
	}
})