Tea.context(function () {
	const t = this.t.bind(this);

	this.columns = [
		{
			title: t('任务编号'),
			key: 'id',
			scopedSlots: { customRender: 'taskIdSlot' },
			width: '7em'
		},
		{
			title: t('任务类型'),
			key: 'type',
			scopedSlots: { customRender: 'taskTypeSlot' }
		},
		{
			title: t('URL类型'),
			key: 'keyType',
			scopedSlots: { customRender: 'keyTypeSlot' }
		},
		{
			title: t('创建时间'),
			dataIndex: 'createdTime',
			key: 'createdTime',
		},
		{
			title: t('所属用户'),
			key: 'user',
			scopedSlots: { customRender: 'userSlot' },
			// className: 'four wide', // b-table does not directly support semantic ui wide classes
			width: '200px' // Approximate from "four wide"
		},
		{
			title: t('任务状态'),
			key: 'status',
			scopedSlots: { customRender: 'statusSlot' },
			// className: 'two wide',
			width: '100px' // Approximate from "two wide"

		},
		{
			title: t('操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			// className: 'two op',
			width: '150px' // Approximate from "two op"
		}
	];

	this.deleteTask = function (taskId) {
		teaweb.confirm(t("确定要删除此任务吗"), function () {
			this.$post(".deleteTask")
				.params({
					taskId: taskId
				})
				.refresh()
		})
	}
})