Tea.context(function () {
	const t = this.t.bind(this)
	this.certIds = []
	this.allChecked = false

	// 定义表格列
	this.columns = [
		{
			title: t("certs_index@证书说明"),
			dataIndex: "name",
			key: "name",
			width: "120px",
			scopedSlots: { customRender: "name" }
		},
		{
			title: t("certs_index@顶级发行组织"),
			dataIndex: "organization",
			key: "organization",
			width: "100px",
			scopedSlots: { customRender: "organization" }
		},
		{
			title: t("certs_index@域名"),
			dataIndex: "dnsNames",
			key: "dnsNames",
			width: "150px",
			scopedSlots: { customRender: "dnsNames" }
		},
		{
			title: t("ocsp_index_js@更新错误信息"),
			dataIndex: "ocspError",
			key: "ocspError",
			width: "300px",
			scopedSlots: { customRender: "ocspError" }
		},
		{
			title: t("certs_index@状态"),
			dataIndex: "status",
			key: "status",
			width: "80px",
			align: "center",
			scopedSlots: { customRender: "status" }
		},
		{
			title: t("certs_index@操作"),
			dataIndex: "actions",
			key: "actions",
			width: "80px",
			scopedSlots: { customRender: "actions" }
		}
	];

	// 行选择配置
	this.rowSelection = {
		onChange: (selectedRowKeys, selectedRows) => {
			this.certIds = selectedRowKeys
		}
	}

	this.$delay(function () {
		let that = this
		this.$watch("allChecked", function (b) {
			let boxes = that.$refs.certCheckboxes
			boxes.forEach(function (box) {
				if (b) {
					box.check()
				} else {
					box.uncheck()
				}
				that.changeCerts()
			})
		})
	})

	this.changeCerts = function () {
		let boxes = this.$refs.certCheckboxes
		let that = this
		this.certIds = []
		boxes.forEach(function (box) {
			if (box.isChecked()) {
				let boxId = box.id
				that.certIds.push(parseInt(boxId.split("_")[1]))
			}
		})
	}

	this.resetAllCerts = function () {
		this.$post(".resetAll")
			.success(function () {
				teaweb.successRefresh(t("ocsp_index_js@操作成功将很快开始重试"))
			})
	}

	this.resetCerts = function () {
		this.$post(".reset")
			.params({ certIds: this.certIds })
			.success(function () {
				teaweb.successRefresh(t("ocsp_index_js@操作成功将很快开始重试"))
			})
	}

	this.ignoreCerts = function () {
		this.$post(".ignore")
			.params({ certIds: this.certIds })
			.success(function () {
				teaweb.successRefresh(t("ocsp_index_js@忽略成功"))
			})
	}

	// 查看证书详情
	this.viewCert = function (certId) {
		teaweb.popup("/servers/certs/certPopup?certId=" + certId, {
			title: t('certs_index@证书详情'),
			height: "28em",
			width: "48em"
		})
	}
})