Tea.context(function () {
	const t = this.t.bind(this)
	// 初始化表格数据
	this.certColumns = [
		{
			title: t('certs_index@证书说明'),
			dataIndex: "name",
			key: "name",
			width: "120px",
			scopedSlots: { customRender: "name" }
		},
		{
			title: t('certs_index@顶级发行组织'),
			dataIndex: "organization",
			key: "organization",
			width: "100px",
			scopedSlots: { customRender: "organization" }
		},
		{
			title: t('certs_index@域名'),
			dataIndex: "dnsNames",
			key: "dnsNames",
			width: "150px",
			scopedSlots: { customRender: "dnsNames" }
		},
		{
			title: t('certs_index@生效日期'),
			dataIndex: "beginDay",
			key: "beginDay",
			width: "90px",
			scopedSlots: { customRender: "beginDay" }
		},
		{
			title: t('certs_index@过期日期'),
			dataIndex: "endDay",
			key: "endDay",
			width: "90px",
			scopedSlots: { customRender: "endDay" }
		},
		{
			title: t('certs_index@引用网站'),
			dataIndex: "countServers",
			key: "countServers",
			width: "80px",
			align: "center",
			scopedSlots: { customRender: "countServers" }
		},
		{
			title: t('certs_index@所属用户'),
			dataIndex: "user",
			key: "user",
			width: "100px",
			scopedSlots: { customRender: "user" }
		},
		{
			title: t('certs_index@状态'),
			dataIndex: "status",
			key: "status",
			width: "80px",
			align: "center",
			scopedSlots: { customRender: "status" }
		},
		{
			title: t('certs_index@操作'),
			dataIndex: "actions",
			key: "actions",
			width: "120px",
			scopedSlots: { customRender: "actions" }
		}
	];

	// 处理合并证书数据和证书信息
	this.processedCerts = this.certs.map(function (cert, index) {
		return {
			...cert,
			...this.certInfos[index],
			status: {
				isOn: this.certInfos[index].isOn,
				isExpired: this.certInfos[index].isExpired
			},
			organization: cert.commonNames && cert.commonNames.length > 0 ? cert.commonNames[cert.commonNames.length - 1] : ""
		};
	}.bind(this));

	// 上传证书
	this.uploadCert = function () {
		teaweb.popup("/servers/certs/uploadPopup?userId=" + this.searchingUserId, {
			title: t('certs_index@上传证书'),
			height: "30em",
			callback: function () {
				teaweb.success(t('certs_index@上传成功'), function () {
					window.location.reload()
				}.bind(this))
			}.bind(this)
		})
	}

	// 批量上传证书
	this.uploadBatch = function () {
		teaweb.popup("/servers/certs/uploadBatchPopup?userId=" + this.searchingUserId, {
			title: t('certs_index@批量上传证书'),
			callback: function () {
				window.location.reload()
			}.bind(this)
		})
	}

	// 删除证书
	this.deleteCert = function (certId) {
		let that = this
		teaweb.confirm(t('certs_index@确定要删除此证书吗'), function () {
			that.$post("/servers/certs/delete")
				.params({
					certId: certId
				})
				.refresh()
		})
	}

	// 查看证书
	this.viewCert = function (certId) {
		teaweb.popup("/servers/certs/certPopup?certId=" + certId, {
			title: t('certs_index@证书详情'),
			height: "28em",
			width: "48em"
		})
	}

	// 修改证书
	this.updateCert = function (certId) {
		teaweb.popup("/servers/certs/updatePopup?certId=" + certId, {
			title: t('certs_index@修改证书'),
			height: "30em",
			callback: function () {
				teaweb.success(t('certs_index@修改成功'), function () {
					window.location.reload()
				}.bind(this))
			}.bind(this)
		})
	}
})