Tea.context(function () {
	const t = this.t.bind(this);
	// {{$t('acme_users_index_js@定义表格列')}}
	this.columns = [
		{
			title: t("acme_users_index_js@用户Email"),
			key: "email",
			dataIndex: "email",
			scopedSlots: { customRender: "email" },
			width: "40%"
		},
		{
			title: t("addPopup@备注"),
			key: "description",
			dataIndex: "description",
			scopedSlots: { customRender: "description" },
			width: "40%"
		},
		{
			title: t("certs_index@操作"),
			key: "actions",
			scopedSlots: { customRender: "actions" },
			width: "20%"
		}
	]

	this.createUser = function () {
		teaweb.popup(Tea.url(".createPopup"), {
			title: t("acme_users_index_js@创建ACME用户"),
			height: "27em",
			width: "44em",
			callback: function () {
				teaweb.success(t("acme_create_js@创建成功"), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.updateUser = function (userId) {
		teaweb.popup("/servers/certs/acme/users/updatePopup?userId=" + userId, {
			title: t('acme_users_index_js@修改ACME用户'),
			height: "27em",
			width: "44em",
			callback: function () {
				teaweb.success(t("acme_users_index_js@保存成功"), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.deleteUser = function (userId) {
		let that = this
		teaweb.confirm(t("acme_users_index_js@确定要删除此用户吗"), function () {
			that.$post(".delete")
				.params({
					userId: userId
				})
				.refresh()
		})
	}
})