Tea.context(function () {
	const t = this.t.bind(this);
	// 表格列定义
	this.columns = [
		{
			title: t("acme_index_js@ACME用户"),
			key: "acmeUser",
			scopedSlots: { customRender: "acmeUser" }
		},
		{
			title: t("acme_index_js@证书域名"),
			key: "domains",
			scopedSlots: { customRender: "domains" }
		},
		{
			title: t("acme_index_js@到期时间"),
			key: "endTime",
			scopedSlots: { customRender: "endTime" }
		},
		{
			title: t("acme_index_js@更新时间"),
			key: "updateTime",
			scopedSlots: { customRender: "updateTime" }
		},
		{
			title: t("acme_index_js@自动续期"),
			key: "autoRenew",
			scopedSlots: { customRender: "autoRenew" },
			width: 100,
			align: "center"
		},
		{
			title: t("acme_index_js@关联证书"),
			key: "cert",
			scopedSlots: { customRender: "cert" },
			width: 100,
			align: "center"
		},
		{
			title: t("certs_index@所属用户"),
			key: "user",
			scopedSlots: { customRender: "user" }
		},
		{
			title: t("certs_index@操作"),
			key: "actions",
			scopedSlots: { customRender: "actions" },
			width: 200
		}
	]

	// 行选择配置
	this.rowSelection = {
		type: 'checkbox',
		onChange(selectedRowKeys, selectedRows) {
			this.selectedTaskIds = selectedRowKeys
		}
	}

	// 行样式函数
	this.rowClassName = function (record, index) {
		if (this.runningIndex === index) {
			return 'warning-row'
		}
		return ''
	}

	this.viewCert = function (certId) {
		teaweb.popup("/servers/certs/certPopup?certId=" + certId, {
			title: t('certs_index@证书详情'),
			height: "28em",
			width: "48em"
		})
	}

	this.updateTask = function (taskId) {
		teaweb.popup("/servers/certs/acme/updateTaskPopup?taskId=" + taskId, {
			title: t('acme_index_js@修改申请任务'),
			width: "45em",
			height: "26em",
			callback: function () {
				teaweb.success(t("acme_index_js@保存成功如果证书域名发生了改变请重新执行生成新证书"), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.deleteTask = function (taskId) {
		let that = this
		teaweb.confirm(t("acme_index_js@确定要删除此任务吗"), function () {
			that.$post("/servers/certs/acme/deleteTask")
				.params({
					taskId: taskId
				})
				.refresh()
		})
	}


	this.isRunning = false
	this.runningIndex = -1
	this.selectedTaskIds = []

	this.runTask = function (index, task) {
		let that = this

		teaweb.confirm(t("acme_index_js@确定要立即执行此任务吗换行将会重新发起证书申请"), function () {
			that.isRunning = true
			that.runningIndex = index

			that.$post(".run")
				.timeout(300)
				.params({
					taskId: task.id
				})
				.success(function (resp) {
					teaweb.success(t("acme_index_js@任务执行成功"), function () {
						teaweb.reload()
					})
				})
				.done(function () {
					that.isRunning = false
					that.runningIndex = -1
				})
		})
	}

	this.showError = function (err) {
		teaweb.popupTip(t("acme_index_js@任务执行失败") + "：" + err)
	}
})