Tea.context(function () {
	const t = this.t.bind(this);
	// {{$t('acme_users_index_js@定义表格列')}}
	this.columns = [
		{
			title: t("access_createPopup@名称"),
			key: "name",
			dataIndex: "name", 
			scopedSlots: { customRender: "name" },
			width: "20%"
		},
		{
			title: t("acme_accounts_index_js@证书服务商"),
			key: "provider",
			dataIndex: "provider",
			scopedSlots: { customRender: "provider" },
			width: "20%"
		},
		{
			title: t("acme_accounts_index_js@EABKid"),
			key: "eabKid",
			dataIndex: "eabKid",
			scopedSlots: { customRender: "eabKid" },
			width: "20%"
		},
		{
			title: t("acme_accounts_index_js@EABHMACKey"),
			key: "eabKey",
			dataIndex: "eabKey",
			scopedSlots: { customRender: "eabKey" },
			width: "20%"
		},
		{
			title: t("certs_index@操作"),
			key: "actions",
			scopedSlots: { customRender: "actions" },
			width: "20%"
		}
	]

	this.createAccount = function () {
		teaweb.popup(".createPopup", {
			title: t("acme_accounts_index_js@创建账号"),
			height: "24em",
			callback: function () {
				teaweb.success(t("acme_users_index_js@保存成功"), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.updateAccount = function (accountId) {
		teaweb.popup(".updatePopup?accountId=" + accountId, {
			title: t("acme_accounts_index_js@修改账号"),
			height: "24em",
			callback: function () {
				teaweb.success(t("acme_users_index_js@保存成功"), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.deleteAccount = function (accountId) {
		teaweb.confirm(t("acme_accounts_index_js@确定要删除此账号吗"), function () {
			this.$post(".delete")
				.params({
					accountId: accountId
				})
				.refresh()
		})
	}
})