Tea.context(function () {
	const t = this.t.bind(this);
	// 表格列配置
	this.columns = [
		{
			title: t('accesslogs@策略名称'),
			dataIndex: 'name',
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' }
		},
		{
			title: t('accesslogs@类型'),
			dataIndex: 'typeName',
			key: 'type',
			width: '150px'
		},
		{
			title: t('accesslogs@主要参数'),
			dataIndex: 'options',
			key: 'options',
			scopedSlots: { customRender: 'optionsSlot' }
		},
		{
			title: t('accesslogs@状态'),
			dataIndex: 'isOn',
			key: 'status',
			scopedSlots: { customRender: 'statusSlot' },
			width: '100px',
			align: 'center'
		},
		{
			title: t('accesslogs@操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '150px',
			align: 'center'
		}
	];

	this.createPolicy = function () {
		teaweb.popup(Tea.url(".createPopup", {
			
		}), {
			title: t('accesslogs@创建日志策略'),
			height: "24em",
			callback: NotifyReloadSuccess(t('cache_index@保存成功'))
		})
	}

	this.deletePolicy = function (policyId) {
		teaweb.confirm(t('accesslogs@确定要删除这个日志策略吗'), function () {
			this.$post(".delete")
				.params({
					policyId: policyId
				})
				.success(function () {
					teaweb.successRefresh(t('cache_index@保存成功'))
				})
		})
	}
})