Tea.context(function () {
	const t = this.t.bind(this);
	this.createUserPlan = function () {
		teaweb.popup("/ns/userPlans/createPopup", {
			title: t('ns_userPlans_index@新购用户套餐'),
			callback: function () {
				teaweb.successRefresh(t('acme_users_index_js@保存成功'))
			}
		})
	}

	this.updateUserPlan = function (userPlanId) {
		teaweb.popup("/ns/userPlans/userPlan/updatePopup?userPlanId=" + userPlanId, {
			title: t('ns_userPlans_index@修改用户套餐'),
			callback: function () {
				teaweb.successRefresh(t('acme_users_index_js@保存成功'))
			}
		})
	}

	this.deleteUserPlan = function (userPlanId) {
		let that = this
		teaweb.confirm(t('ns_userPlans_index@确定要删除此套餐吗'), function () {
			that.$post("/ns/userPlans/userPlan/delete")
				.params({
					userPlanId: userPlanId
				})
				.success(function () {
					teaweb.successRefresh(t('iplists@删除成功'))
				})
		})
	}
})