Tea.context(function () {
	const t = this.t.bind(this)

	// let that = this

	// 表格列定义
	this.columns = [
		{
			title: '',
			key: 'handle',
			scopedSlots: { customRender: 'handleSlot' },
			width: '3em',
			align: 'center'
		},
		{
			title: t('ns_routes_index@线路名称Col'),
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' }
		},
		{
			title: t('ns_routes_index@代号Col'),
			key: 'code',
			scopedSlots: { customRender: 'codeSlot' },
			width: '8em' // 根据原表格 two wide 估算
		},
		{
			title: t('ns_routes_index@优先级Col'),
			key: 'priority',
			scopedSlots: { customRender: 'prioritySlot' },
			width: '8em', // 根据原表格 two wide 估算
			align: 'center' // 估算添加居中
		},
		{
			title: t('ns_routes_index@公用Col'),
			key: 'isPublic',
			scopedSlots: { customRender: 'publicSlot' },
			width: '8em', // 根据原表格 two wide 估算
			align: 'center' // 估算添加居中
		},
		{
			title: t('ns_routes_index@状态Col'),
			key: 'isOn',
			scopedSlots: { customRender: 'statusSlot' },
			width: '8em', // 根据原表格 two wide 估算
			align: 'center' // 估算添加居中
		},
		{
			title: t('ns_routes_index@操作Col'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '10em', // 根据原表格 two op 估算
			align: 'center' // 估算添加居中
		}
	];

	this.$delay(function () {
		// let that = this
		// sortTable(function (ids) {
		// 	that.$post(".sort")
		// 		.params({
		// 			routeIds: ids
		// 		})
		// 		.success(function () {
		// 			teaweb.successToast(t('ns_routes_index@排序保存成功Toast'))
		// 		})
		// })
	})

	this.createRoute = function () {
		teaweb.popup("/ns/routes/createPopup", {
			title: t('ns_routes_index@创建线路PopupTitle'),
			width: "50em",
			height: "30em",
			callback: function () {
				teaweb.success(t('ns_routes_index@保存成功'), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.updateRoute = function (routeId) {
		teaweb.popup("/ns/routes/updatePopup?routeId=" + routeId, {
			title: t('ns_routes_index@修改线路PopupTitle'),
			width: "50em",
			height: "30em",
			callback: function () {
				teaweb.success(t('ns_routes_index@保存成功'), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.deleteRoute = function (routeId) {
		let that = this
		teaweb.confirm(t('ns_routes_index@确定要删除此线路吗'), function () {
			that.$post(".delete")
				.params({
					routeId: routeId
				})
				.success(function () {
					teaweb.reload()
				})
		})
	}

	this.handleSort = function (ids) {
		this.$post(".sort")
			.params({
				routeIds: ids
			})
			.success(function () {
				teaweb.success(t('ns_routes_index@排序成功'))
			})
	}
})