Tea.context(function () {
	const t = this.t.bind(this)
	// let that = this

	// 表格列定义
	this.columns = [
		{
			title: '',
			key: 'handle',
			scopedSlots: { customRender: 'handleSlot' },
			width: '3em',
			align: 'center'
		},
		{
			title: t('ns_routes_categories_index@分类名称Col'),
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' }
		},
		{
			title: t('ns_routes_categories_index@状态Col'),
			key: 'isOn',
			scopedSlots: { customRender: 'statusSlot' },
			width: '10%', // 原 width6 估算
			align: 'center' // 估算添加居中
		},
		{
			title: t('ns_routes_categories_index@操作Col'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '180px', // 原 two op 估算
			align: 'center' // 估算添加居中
		}
	];

	this.$delay(function () {
		let that = this
		// sortTable(function (ids) {
		// 	that.$post(".sort")
		// 		.params({
		// 			categoryIds: ids
		// 		})
		// 		.success(function () {
		// 			teaweb.successToast(t('ns_routes_categories_index@排序保存成功'))
		// 		})
		// })
	})

	this.createCategory = function () {
		teaweb.popup(".createPopup", {
			title: t('ns_routes_categories_index@创建分类'),
			callback: function () {
				teaweb.successRefresh(t('ns_routes_categories_index@保存成功'))
			}
		})
	}

	this.updateCategory = function (categoryId) {
		teaweb.popup(".category.updatePopup?categoryId=" + categoryId, {
			title: t('ns_routes_categories_index@修改分类'),
			callback: function () {
				teaweb.successRefresh(t('ns_routes_categories_index@保存成功'))
			}
		})
	}

	this.deleteCategory = function (categoryId) {
		let that = this
		teaweb.confirm(t('ns_routes_categories_index@确定要删除此分类吗'), function () {
			this.$post(".category.delete")
				.params({
					categoryId: categoryId
				})
				.success(function () {
					teaweb.successRefresh(t('ns_routes_categories_index@删除成功'))
				})

		})
	}

	this.handleSort = function (ids) {
		this.$post(".sort")
			.params({
				categoryIds: ids
			})
			.success(function () {
				teaweb.success(t('ns_routes_categories_index@排序成功'))
			})
	}
})