Tea.context(function () {
	const t = this.t.bind(this)
	let that = this

	// 表格列定义
	this.columns = [
		{
			title: '',
			key: 'handle',
			scopedSlots: { customRender: 'handleSlot' },
			width: '50px',
			align: 'center'
		},
		{
			title: t('ns_plans_index@套餐名称Col'),
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' },
			width: '150px'
		},
		{
			title: t('ns_plans_index@价格Col'),
			key: 'price',
			scopedSlots: { customRender: 'priceSlot' },
			width: '100px'
		},
		{
			title: t('ns_plans_index@最小TTLCol'),
			key: 'minTTL',
			scopedSlots: { customRender: 'minTTLSlot' },
			width: '100px',
			align: 'center'
		},
		{
			title: t('ns_plans_index@域名数量Col'),
			key: 'maxDomains',
			scopedSlots: { customRender: 'maxDomainsSlot' },
			width: '100px',
			align: 'center'
		},
		{
			title: t('ns_plans_index@单域名记录数Col'),
			key: 'maxRecordsPerDomain',
			scopedSlots: { customRender: 'maxRecordsPerDomainSlot' },
			width: '100px',
			align: 'center'
		},
		{
			title: t('ns_plans_index@负载均衡条数Col'),
			key: 'maxLoadBalanceRecordsPerRecord',
			scopedSlots: { customRender: 'maxLoadBalanceRecordsPerRecordSlot' },
			width: '100px',
			align: 'center'
		},
		{
			title: t('ns_plans_index@自定义线路数Col'),
			key: 'maxCustomRoutes',
			scopedSlots: { customRender: 'maxCustomRoutesSlot' },
			width: '100px',
			align: 'center'
		},
		{
			title: t('ns_plans_index@内置线路Col'),
			key: 'builtInRoutes',
			scopedSlots: { customRender: 'builtInRoutesSlot' },
			width: '100px'
		},
		{
			title: t('ns_plans_index@健康检查Col'),
			key: 'healthCheck',
			scopedSlots: { customRender: 'healthCheckSlot' },
			width: '100px',
			align: 'center'
		},
		{
			title: t('ns_plans_index@状态Col'),
			key: 'isOn',
			scopedSlots: { customRender: 'statusSlot' },
			width: '100px', // 原 width6 估算
			align: 'center'
		},
		{
			title: t('ns_plans_index@操作Col'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '180px', // 原 two op 估算
			align: 'center'
		}
	];

	this.$delay(function () {
		this.sortTable()
	})

	this.createPlan = function () {
		teaweb.popup("/ns/plans/createPopup", {
			title: t('ns_plans_index@创建套餐PopupTitle'),
			width: "42em",
			height: "30em",
			callback: function () {
				teaweb.successRefresh(t('ns_plans_index@保存成功'))
			}
		})
	}

	this.updatePlan = function (planId) {
		teaweb.popup("/ns/plans/plan/updatePopup?planId=" + planId, {
			title: t('ns_plans_index@修改套餐PopupTitle'),
			width: "42em",
			height: "30em",
			callback: function () {
				teaweb.successRefresh(t('ns_plans_index@保存成功'))
			}
		})
	}

	this.deletePlan = function (planId) {
		let that = this
		teaweb.confirm(t('ns_plans_index@确定要删除此套餐吗'), function () {
			that.$post("/ns/plans/plan/delete")
				.params({
					planId: planId
				})
				.success(function () {
					teaweb.successRefresh(t('ns_plans_index@删除成功'))
				})
		})
	}

	this.sortTable = function () {
		let that = this
		sortTable(function (ids) {
			that.$post("/ns/plans/sort")
				.params({
					ids: ids
				})
				.success(function () {
					teaweb.successToast(t('ns_plans_index@保存成功Toast'), 1000)
				})
		})
	}

	this.handleSort = function (ids) {
		this.$post("/ns/plans/sort")
			.params({
				planIds: ids
			})
			.success(function () {
				teaweb.success(t('ns_plans_index@排序成功Toast'))
			})
	}
})