Tea.context(function () {
	const t = this.t.bind(this);
	this.isLoading = true

	this.$delay(function () {
		this.$post("$")
			.success(function (resp) {
				for (let k in resp.data) {
					this[k] = resp.data[k]
				}

				this.$delay(function () {
					this.reloadHourlyTrafficChart()
					this.reloadTopDomainsChart()
					this.reloadTopNodesChart()
					this.reloadCPUChart()
					
					// 监听窗口大小变化，重新渲染图表
					window.addEventListener('resize', this.resizeAllCharts)
				})

				this.isLoading = false
			})
	})
	
	// 响应式调整所有图表
	this.resizeAllCharts = function() {
		if (this.trafficTab == "hourly") {
			this.reloadHourlyTrafficChart()
		} else if (this.trafficTab == "daily") {
			this.reloadDailyTrafficChart()
		}
		
		this.reloadTopDomainsChart()
		this.reloadTopNodesChart()
		
		if (this.nodeStatusTab == "cpu") {
			this.reloadCPUChart()
		} else if (this.nodeStatusTab == "memory") {
			this.reloadMemoryChart()
		} else if (this.nodeStatusTab == "load") {
			this.reloadLoadChart()
		}
	}

	/**
	 * 流量统计
	 */
	this.trafficTab = "hourly"

	this.selectTrafficTab = function (tab) {
		this.trafficTab = tab
		if (tab == "hourly") {
			this.$delay(function () {
				this.reloadHourlyTrafficChart()
			})
		} else if (tab == "daily") {
			this.$delay(function () {
				this.reloadDailyTrafficChart()
			})
		}
	}

	this.reloadHourlyTrafficChart = function () {
		let stats = this.hourlyStats
		this.reloadTrafficChart("hourly-traffic-chart", t('ns_index_js@流量统计'), stats, function (args) {
			return stats[args.dataIndex].day + " " + stats[args.dataIndex].hour + t('ns_index_js@时') + "<br/>" + t('ns_index_js@流量Tooltip') + ": " + teaweb.formatBytes(stats[args.dataIndex].bytes) + "<br/>" + t('ns_index_js@请求数') + "：" + teaweb.formatNumber(stats[args.dataIndex].countRequests)
		})
	}

	this.reloadDailyTrafficChart = function () {
		let stats = this.dailyStats
		this.reloadTrafficChart("daily-traffic-chart", t('ns_index_js@流量统计'), stats, function (args) {
			return stats[args.dataIndex].day + "<br/>" + t('ns_index_js@流量Tooltip') + ": " + teaweb.formatBytes(stats[args.dataIndex].bytes) + "<br/>" + t('ns_index_js@请求数') + "：" + teaweb.formatNumber(stats[args.dataIndex].countRequests)
		})
	}

	this.reloadTrafficChart = function (chartId, name, stats, tooltipFunc) {
		let chartBox = document.getElementById(chartId)
		if (chartBox == null) {
			return
		}

		let axis = teaweb.bytesAxis(stats, function (v) {
			return v.bytes
		})

		let chart = teaweb.initChart(chartBox)
		let option = {
			xAxis: {
				data: stats.map(function (v) {
					if (v.hour != null) {
						return v.hour
					}
					return v.day
				})
			},
			yAxis: {
				axisLabel: {
					formatter: function (value) {
						return value + axis.unit
					}
				}
			},
			tooltip: {
				show: true,
				trigger: "item",
				backgroundColor: getCssVariable('--color-bg', '#app'),
				borderColor: getCssVariable('--color-border', '#app'),
				textStyle: {
					color: getCssVariable('--color-text-active', '#app'),
				},
				formatter: tooltipFunc,
			},
			grid: {
				left: 50,
				top: 20,
				right: 20,
				bottom: 30
			},
			series: [
				{
					name: t('ns_index_js@流量Series'),
					type: "line",
					data: stats.map(function (v) {
						return v.bytes / axis.divider
					}),
					itemStyle: {
						color: getCssVariable('--color-text-active', '#'+chart.getDom().id),
					},
					areaStyle: {
						color: getCssVariable('--color-text-active', '#'+chart.getDom().id),
						opacity: 0.2
					},
					smooth: true
				}
			],
			animation: true
		}
		chart.setOption(option)
		chart.resize()
	}

	// 域名排行
	this.reloadTopDomainsChart = function () {
		let that = this
		let axis = teaweb.countAxis(this.topDomainStats, function (v) {
			return v.countRequests
		})
		teaweb.renderBarChart({
			id: "top-domains-chart",
			name: t('ns_index_js@域名Series'),
			values: this.topDomainStats,
			x: function (v) {
				return v.domainName
			},
			tooltip: function (args, stats) {
				return stats[args.dataIndex].domainName + "<br/>" + t('ns_index_js@请求数') + "：" + " " + teaweb.formatNumber(stats[args.dataIndex].countRequests) + "<br/>" + t('ns_index_js@流量Tooltip') + "：" + teaweb.formatBytes(stats[args.dataIndex].bytes)
			},
			value: function (v) {
				return v.countRequests / axis.divider;
			},
			axis: axis,
			click: function (args, stats) {
				window.location = "/ns/domains/domain?domainId=" + stats[args.dataIndex].domainId
			},
			grid: {
				top: 20,
				bottom: 20
			}
		})
	}

	// 节点排行
	this.reloadTopNodesChart = function () {
		let that = this
		let axis = teaweb.countAxis(this.topNodeStats, function (v) {
			return v.countRequests
		})
		teaweb.renderBarChart({
			id: "top-nodes-chart",
			name: t('ns_index_js@节点Series'),
			values: this.topNodeStats,
			x: function (v) {
				return v.nodeName
			},
			tooltip: function (args, stats) {
				return stats[args.dataIndex].nodeName + "<br/>" + t('ns_index_js@请求数') + "：" + " " + teaweb.formatNumber(stats[args.dataIndex].countRequests) + "<br/>" + t('ns_index_js@流量Tooltip') + "：" + teaweb.formatBytes(stats[args.dataIndex].bytes)
			},
			value: function (v) {
				return v.countRequests / axis.divider;
			},
			axis: axis,
			click: function (args, stats) {
				window.location = "/ns/clusters/cluster/node?nodeId=" + stats[args.dataIndex].nodeId + "&clusterId=" + stats[args.dataIndex].clusterId
			},
			grid: {
				top: 20,
				bottom: 20
			}
		})
	}

	/**
	 * 系统信息
	 */
	this.nodeStatusTab = "cpu"

	this.selectNodeStatusTab = function (tab) {
		this.nodeStatusTab = tab
		this.$delay(function () {
			switch (tab) {
				case "cpu":
					this.reloadCPUChart()
					break
				case "memory":
					this.reloadMemoryChart()
					break
				case "load":
					this.reloadLoadChart()
					break
			}
		})
	}

	this.reloadCPUChart = function () {
		let axis = {unit: "%", divider: 1}
		teaweb.renderLineChart({
			id: "cpu-chart",
			name: t('ns_index_js@CPUSeries'),
			values: this.cpuValues,
			x: function (v) {
				return v.time
			},
			tooltip: function (args, stats) {
				return stats[args.dataIndex].time + "：" + (Math.ceil(stats[args.dataIndex].value * 100 * 100) / 100) + "%"
			},
			value: function (v) {
				return v.value * 100;
			},
			axis: axis,
			max: 100,
			grid: {
				top: 20,
				bottom: 20
			}
		})
	}

	this.reloadMemoryChart = function () {
		let axis = {unit: "%", divider: 1}
		teaweb.renderLineChart({
			id: "memory-chart",
			name: t('ns_index_js@内存Series'),
			values: this.memoryValues,
			x: function (v) {
				return v.time
			},
			tooltip: function (args, stats) {
				return stats[args.dataIndex].time + "：" + (Math.ceil(stats[args.dataIndex].value * 100 * 100) / 100) + "%"
			},
			value: function (v) {
				return v.value * 100;
			},
			axis: axis,
			max: 100,
			grid: {
				top: 20,
				bottom: 20
			}
		})
	}

	this.reloadLoadChart = function () {
		let axis = {unit: "", divider: 1}
		let max = this.loadValues.$map(function (k, v) {
			return v.value
		}).$max()
		if (max < 10) {
			max = 10
		} else if (max < 20) {
			max = 20
		} else if (max < 100) {
			max = 100
		} else {
			max = null
		}
		teaweb.renderLineChart({
			id: "load-chart",
			name: t('ns_index_js@负载Series'),
			values: this.loadValues,
			x: function (v) {
				return v.time
			},
			tooltip: function (args, stats) {
				return stats[args.dataIndex].time + "：" + (Math.ceil(stats[args.dataIndex].value * 100) / 100)
			},
			value: function (v) {
				return v.value;
			},
			axis: axis,
			max: max,
			grid: {
				top: 20,
				bottom: 20
			}
		})
	}

	// 添加卡片点击跳转方法
	this.goToPage = function (url) {
		window.location = url;
	};
})