Tea.context(function () {
	const t = this.t.bind(this);
	// 表格列定义
	this.columns = [
		{
			title: t('ns_domains_records_index_col@名称'),
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' },
			widht: '15%'
		},
		{
			title: t('ns_domains_records_index_col@类型'),
			key: 'type',
			scopedSlots: { customRender: 'typeSlot' },
			widht: '10%'
		},
		{
			title: t('ns_domains_records_index_col@记录值'),
			key: 'value',
			scopedSlots: { customRender: 'valueSlot' }
		},
		{
			title: t('ns_domains_records_index_col@TTL'),
			key: 'ttl',
			scopedSlots: { customRender: 'ttlSlot' },
			widht: '10%'
		},
		{
			title: t('ns_domains_records_index_col@线路'),
			key: 'routes',
			scopedSlots: { customRender: 'routesSlot' },
			widht: '15%'
		},
		// 健康检查列，根据 domainHealthCheckIsOn 条件添加
		// ... (稍后根据 this.domainHealthCheckIsOn 添加)
		{
			title: t('ns_domains_records_index_col@解析次数'),
			key: 'stat',
			scopedSlots: { customRender: 'statSlot' },
			widht: '10%',
			align: 'center' // 根据原表格样式添加居中
		},
		{
			title: t('ns_domains_records_index_col@状态'),
			key: 'isOn',
			scopedSlots: { customRender: 'statusSlot' },
			widht: '8em' // 根据原表格样式调整
		},
		{
			title: t('ns_domains_records_index_col@操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '8em', // 根据原表格样式调整
			align: 'center' // 根据原表格样式添加居中
		}
	];

	// 动态添加健康检查列
	if (this.domainHealthCheckIsOn) {
		this.columns.splice(5, 0, {
			title: t('ns_domains_records_index_col@健康检查'),
			key: 'healthCheck',
			scopedSlots: { customRender: 'healthCheckSlot' },
			width: '8em',
			align: 'center'
		});
	}

	this.createRecord = function () {
		teaweb.popup(".createPopup?domainId=" + this.domain.id, {
			height: "35em",
			title: t('ns_domains_records_index@创建记录PopupTitle'),
			callback: function () {
				teaweb.success(t('ns_domains_records_index@保存成功Message'), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.updateRecord = function (recordId) {
		teaweb.popup(".updatePopup?recordId=" + recordId, {
			height: "35em",
			title: t('ns_domains_records_index@更新记录PopupTitle'),
			callback: function () {
				teaweb.success(t('ns_domains_records_index@保存成功Message'), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.deleteRecord = function (recordId) {
		let that = this
		teaweb.confirm(t('ns_domains_records_index@删除确认Message'), function () {
			that.$post(".delete")
				.params({
					recordId: recordId
				})
				.success(function () {
					teaweb.reload()
				})
		})
	}

	this.searchWithName = function (keyword) {
		this.keyword = "name:\"" + keyword + "\""
		this.$delay(function () {
			this.$refs.recordsSearchForm.submit()
		})
	}

	this.searchWithValue = function (keyword) {
		this.keyword = "value:\"" + keyword + "\""
		this.$delay(function () {
			this.$refs.recordsSearchForm.submit()
		})
	}

	this.showStat = function (recordId) {
		teaweb.popup(".statPopup?recordId=" + recordId, {
			title: t('ns_domains_records_index@解析次数PopupTitle'),
		})
	}

	this.updateRecordHealthCheck = function (recordId) {
		teaweb.popup(".healthCheckPopup?recordId=" + recordId, {
			height: "26em",
			title: t('ns_domains_records_index@更新健康检查PopupTitle'),
			callback: function () {
				teaweb.success(t('ns_domains_records_index@设置成功Message'), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.upRecord = function (record) {
		record.isUp = true

		this.$post(".updateUp")
			.params({
				recordId: record.id
			})
			.success(function () {
				teaweb.success(t('ns_domains_records_index@操作成功Message'), function () {
					teaweb.reload()
				})
			})
	}

	this.formatTTL = function (ttl) {
		if (ttl % 86400 == 0) {
			let days = ttl / 86400
			return days + t('ns_domains_records_index_formatTTL@天')
		}
		if (ttl % 3600 == 0) {
			let hours = ttl / 3600
			return hours + t('ns_domains_records_index_formatTTL@小时')
		}
		if (ttl % 60 == 0) {
			let minutes = ttl / 60
			return minutes + t('ns_domains_records_index_formatTTL@分钟')
		}
		return ttl + t('ns_domains_records_index_formatTTL@秒')
	}
})