Tea.context(function () {
	const t = this.t.bind(this);
	// 表格列定义
	this.columns = [
		{
			title: t('密钥名称'),
			dataIndex: 'name',
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' },
			width: '20%'
		},
		{
			title: t('算法'),
			dataIndex: 'algoName',
			key: 'algoName',
			scopedSlots: { customRender: 'algoNameSlot' },
			width: '20%'
		},
		{
			title: t('密码'),
			dataIndex: 'secret',
			key: 'secret',
			scopedSlots: { customRender: 'secretSlot' }
		},
		{
			title: t('密码类型'),
			dataIndex: 'secretTypeName',
			key: 'secretTypeName',
			scopedSlots: { customRender: 'secretTypeNameSlot' },
			width: '15%'
		},
		{
			title: t('状态'),
			dataIndex: 'isOn',
			key: 'isOn',
			scopedSlots: { customRender: 'statusSlot' },
			width: '10%',
			align: 'center'
		},
		{
			title: t('操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '10%',
			align: 'center'
		}
	];

	this.createKey = function () {
		teaweb.popup(Tea.url(".createPopup?domainId=" + this.domain.id), {
			height: "24em",
			title: t("创建密钥"),
			callback: function () {
				teaweb.successRefresh(t("保存成功"))
			}
		})
	}

	this.updateKey = function (keyId) {
		teaweb.popup(Tea.url(".updatePopup?keyId=" + keyId), {
			height: "27em",
			title: t("更新密钥"),
			callback: function () {
				teaweb.successRefresh(t("保存成功"))
			}
		})
	}

	this.deleteKey = function (keyId) {
		teaweb.confirm(t("确定要删除这个密钥吗？"), function () {
			this.$post(".delete")
				.params({
					keyId: keyId
				})
				.success(function () {
					teaweb.successRefresh(t("删除成功"))
				})
		})
	}
})