Tea.context(function () {
	const t = this.t.bind(this)
	let that = this // 保留 that

	// 不再需要手动添加 isChecked
	// this.domains = this.domains.map(function (v) {
	// 	v.isChecked = false
	// 	return v
	// })

	// 存放选中的行 Key (域名 ID)
	this.selectedRowKeys = [];

	// 表格列定义 (移除 checkbox 列)
	this.columns = [
		{
			title: t('域名'),
			dataIndex: 'name',
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' }
		},
		{
			title: t('集群'),
			dataIndex: 'cluster.name',
			key: 'cluster',
			scopedSlots: { customRender: 'clusterSlot' },
			width: '20%'
		},
		{
			title: t('用户'),
			dataIndex: 'user.fullname',
			key: 'user',
			scopedSlots: { customRender: 'userSlot' },
			width: '20%'
		},
		{
			title: t('状态'),
			dataIndex: 'isOn',
			key: 'status',
			scopedSlots: { customRender: 'statusSlot' },
			width: '8em',
			align: 'center'
		},
		{
			title: t('操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '8em',
			align: 'center'
		}
	];
	
	// 不再需要 selectedAll 和对应的 watcher
	// this.selectedAll = false; 
	// this.$delay(function () {
	// 	this.$watch("selectedAll", function (v) {
	// 		...
	// 	})
	// })

	this.$delay(function () {
		this.changeUserId(this.userId)
	})

	this.deleteDomain = function (domainId) {
		let that = this
		teaweb.confirm(t("确定要删除此域名吗？"), function () {
			that.$post("/ns/domains/delete")
				.params({
					domainId: domainId
				})
				.success(function () {
					teaweb.reload()
				})
		})
	}

	this.hasGroups = false
	this.changeUserId = function (userId) {
		this.$post("/ns/domains/groups/options")
			.params({
				userId: userId
			})
			.success(function (resp) {
				this.hasGroups = resp.data.groups.length > 0
				if (this.hasGroups) {
					this.$delay(function () {
						this.$refs.groupSelector.reload(userId)
					})
				}
			})
	}

	/**
	 * 批量操作状态
	 */
	this.hasSelectedDomains = false
	this.hasVerifyingDomains = false

	// b-table 选择变化时的回调
	this.onTableSelectChange = function (selectedRowKeys, selectedRows) {
		this.selectedRowKeys = selectedRowKeys;
		let hasVerifying = false;
		selectedRows.forEach(function (row) {
			if (row.status == "none") {
				hasVerifying = true;
			}
		});
		this.hasSelectedDomains = selectedRowKeys.length > 0;
		this.hasVerifyingDomains = hasVerifying;
	};

	// 不再需要 changeSelectedDomains 这个函数了，逻辑移到 onTableSelectChange 中
	/*this.changeSelectedDomains = function () {
		if (this.$refs == null) {
			return
		}
		let checkboxes = this.$refs.domainCheckbox
		if (checkboxes != null) {
			let hasSelectedDomains = false
			let hasVerifyingDomains = false
			checkboxes.forEach(function (checkbox) {
				if (checkbox.isChecked()) {
					hasSelectedDomains = true
					let status = checkbox.$el.getAttribute("status")
					if (status == "none") {
						hasVerifyingDomains = true
					}
				}
			})
			this.hasSelectedDomains = hasSelectedDomains
			this.hasVerifyingDomains = hasVerifyingDomains
			return
		}
	}*/

	// 取消选中，现在只需要清空 selectedRowKeys
	this.cancelDomains = function () {
		this.selectedRowKeys = [];
		// 手动触发一次更新，以确保 hasSelectedDomains 等状态更新
		this.onTableSelectChange([], []); 
	}

	// 批量删除域名，直接使用 selectedRowKeys
	this.deleteDomains = function () {
		let that = this
		let domainIds = this.selectedRowKeys
		if (domainIds.length == 0) {
			teaweb.warn(t("请先选中要删除的域名"));
			return;
		}

		teaweb.confirm(t("确定要删除选中的域名吗？"), function () {
			that.$post(".deletePage")
				.params({
					domainIds: domainIds
				})
				.success(function () {
					teaweb.successRefresh(t("删除成功"))
				})
		})
	}
})